/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.HardwareBuffer;
import android.media.AudioPresentation;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaDescrambler;
import android.media.MediaDrmThrowable;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.PersistableBundle;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;

public final class MediaCodec {
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_DECODE_ONLY = 32;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_PARTIAL_FRAME = 8;
    @Deprecated
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int CONFIGURE_FLAG_DETACHED_SURFACE = 8;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CONFIGURE_FLAG_USE_BLOCK_MODEL = 2;
    public static final int CONFIGURE_FLAG_USE_CRYPTO_ASYNC = 4;
    public static final int CRYPTO_MODE_AES_CBC = 2;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    @Deprecated
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final String PARAMETER_KEY_HDR10_PLUS_INFO = "hdr10-plus-info";
    public static final String PARAMETER_KEY_LOW_LATENCY = "low-latency";
    public static final String PARAMETER_KEY_OFFSET_TIME = "time-offset-us";
    public static final String PARAMETER_KEY_QP_OFFSET_MAP = "qp-offset-map";
    public static final String PARAMETER_KEY_QP_OFFSET_RECTS = "qp-offset-rects";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_SUSPEND_TIME = "drop-start-time-us";
    public static final String PARAMETER_KEY_TUNNEL_PEEK = "tunnel-peek";
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;

    MediaCodec() {
        throw new RuntimeException("Stub!");
    }

    public void configure(@Nullable MediaFormat format, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
        throw new RuntimeException("Stub!");
    }

    public void configure(@Nullable MediaFormat format, @Nullable Surface surface, int flags, @Nullable MediaDescrambler descrambler) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public static MediaCodec createByCodecName(@NonNull String name) throws IOException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public static MediaCodec createDecoderByType(@NonNull String type) throws IOException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public static MediaCodec createEncoderByType(@NonNull String type) throws IOException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public native Surface createInputSurface();

    @NonNull
    public static Surface createPersistentInputSurface() {
        throw new RuntimeException("Stub!");
    }

    public int dequeueInputBuffer(long timeoutUs) {
        throw new RuntimeException("Stub!");
    }

    public int dequeueOutputBuffer(@NonNull BufferInfo info, long timeoutUs) {
        throw new RuntimeException("Stub!");
    }

    public void detachOutputSurface() {
        throw new RuntimeException("Stub!");
    }

    protected void finalize() {
        throw new RuntimeException("Stub!");
    }

    public void flush() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public native String getCanonicalName();

    @NonNull
    public MediaCodecInfo getCodecInfo() {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public ByteBuffer getInputBuffer(int index) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    @NonNull
    public ByteBuffer[] getInputBuffers() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public MediaFormat getInputFormat() {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public Image getInputImage(int index) {
        throw new RuntimeException("Stub!");
    }

    public PersistableBundle getMetrics() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public String getName() {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public ByteBuffer getOutputBuffer(int index) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    @NonNull
    public ByteBuffer[] getOutputBuffers() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public MediaFormat getOutputFormat() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public MediaFormat getOutputFormat(int index) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public OutputFrame getOutputFrame(int index) {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public Image getOutputImage(int index) {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public ParameterDescriptor getParameterDescriptor(@NonNull String name) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public QueueRequest getQueueRequest(int index) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public List<String> getSupportedVendorParameters() {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public static Image mapHardwareBuffer(@NonNull HardwareBuffer hardwareBuffer) {
        throw new RuntimeException("Stub!");
    }

    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        throw new RuntimeException("Stub!");
    }

    public void queueInputBuffers(int index, @NonNull ArrayDeque<BufferInfo> bufferInfos) {
        throw new RuntimeException("Stub!");
    }

    public void queueSecureInputBuffer(int index, int offset, @NonNull CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        throw new RuntimeException("Stub!");
    }

    public void queueSecureInputBuffers(int index, @NonNull ArrayDeque<BufferInfo> bufferInfos, @NonNull ArrayDeque<CryptoInfo> cryptoInfos) {
        throw new RuntimeException("Stub!");
    }

    public void release() {
        throw new RuntimeException("Stub!");
    }

    public void releaseOutputBuffer(int index, boolean render) {
        throw new RuntimeException("Stub!");
    }

    public void releaseOutputBuffer(int index, long renderTimestampNs) {
        throw new RuntimeException("Stub!");
    }

    public void reset() {
        throw new RuntimeException("Stub!");
    }

    public void setAudioPresentation(@NonNull AudioPresentation presentation) {
        throw new RuntimeException("Stub!");
    }

    public void setCallback(@Nullable Callback cb) {
        throw new RuntimeException("Stub!");
    }

    public void setCallback(@Nullable Callback cb, @Nullable Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setInputSurface(@NonNull Surface surface) {
        throw new RuntimeException("Stub!");
    }

    public void setOnFirstTunnelFrameReadyListener(@Nullable Handler handler, @Nullable OnFirstTunnelFrameReadyListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnFrameRenderedListener(@Nullable OnFrameRenderedListener listener, @Nullable Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOutputSurface(@NonNull Surface surface) {
        throw new RuntimeException("Stub!");
    }

    public void setParameters(@Nullable Bundle params) {
        throw new RuntimeException("Stub!");
    }

    public native void setVideoScalingMode(int var1);

    public native void signalEndOfInputStream();

    public void start() {
        throw new RuntimeException("Stub!");
    }

    public void stop() {
        throw new RuntimeException("Stub!");
    }

    public void subscribeToVendorParameters(@NonNull List<String> names) {
        throw new RuntimeException("Stub!");
    }

    public void unsubscribeFromVendorParameters(@NonNull List<String> names) {
        throw new RuntimeException("Stub!");
    }

    public final class QueueRequest {
        QueueRequest() {
            throw new RuntimeException("Stub!");
        }

        public void queue() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setByteBufferParameter(@NonNull String key, @NonNull ByteBuffer value) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setEncryptedLinearBlock(@NonNull LinearBlock block, int offset, int size, @NonNull CryptoInfo cryptoInfo) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setFlags(int flags) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setFloatParameter(@NonNull String key, float value) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setHardwareBuffer(@NonNull HardwareBuffer buffer) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setIntegerParameter(@NonNull String key, int value) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setLinearBlock(@NonNull LinearBlock block, int offset, int size) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setLongParameter(@NonNull String key, long value) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setMultiFrameEncryptedLinearBlock(@NonNull LinearBlock block, @NonNull ArrayDeque<BufferInfo> bufferInfos, @NonNull ArrayDeque<CryptoInfo> cryptoInfos) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setMultiFrameLinearBlock(@NonNull LinearBlock block, @NonNull ArrayDeque<BufferInfo> infos) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setPresentationTimeUs(long presentationTimeUs) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public QueueRequest setStringParameter(@NonNull String key, @NonNull String value) {
            throw new RuntimeException("Stub!");
        }
    }

    public static class ParameterDescriptor {
        ParameterDescriptor() {
            throw new RuntimeException("Stub!");
        }

        public boolean equals(Object o) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public String getName() {
            throw new RuntimeException("Stub!");
        }

        public int getType() {
            throw new RuntimeException("Stub!");
        }

        public int hashCode() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class OutputFrame {
        OutputFrame() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public ArrayDeque<BufferInfo> getBufferInfos() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public Set<String> getChangedKeys() {
            throw new RuntimeException("Stub!");
        }

        public int getFlags() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public MediaFormat getFormat() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public HardwareBuffer getHardwareBuffer() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public LinearBlock getLinearBlock() {
            throw new RuntimeException("Stub!");
        }

        public long getPresentationTimeUs() {
            throw new RuntimeException("Stub!");
        }
    }

    public static interface OnFrameRenderedListener {
        public void onFrameRendered(@NonNull MediaCodec var1, long var2, long var4);
    }

    public static interface OnFirstTunnelFrameReadyListener {
        public void onFirstTunnelFrameReady(@NonNull MediaCodec var1);
    }

    public static final class MetricsConstants {
        public static final String CODEC = "android.media.mediacodec.codec";
        public static final String ENCODER = "android.media.mediacodec.encoder";
        public static final String HEIGHT = "android.media.mediacodec.height";
        public static final String MIME_TYPE = "android.media.mediacodec.mime";
        public static final String MODE = "android.media.mediacodec.mode";
        public static final String MODE_AUDIO = "audio";
        public static final String MODE_VIDEO = "video";
        public static final String ROTATION = "android.media.mediacodec.rotation";
        public static final String SECURE = "android.media.mediacodec.secure";
        public static final String WIDTH = "android.media.mediacodec.width";

        MetricsConstants() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class LinearBlock {
        LinearBlock() {
            throw new RuntimeException("Stub!");
        }

        protected void finalize() {
            throw new RuntimeException("Stub!");
        }

        public static boolean isCodecCopyFreeCompatible(@NonNull String[] codecNames) {
            throw new RuntimeException("Stub!");
        }

        public boolean isMappable() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public ByteBuffer map() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public static LinearBlock obtain(int capacity, @NonNull String[] codecNames) {
            throw new RuntimeException("Stub!");
        }

        public void recycle() {
            throw new RuntimeException("Stub!");
        }
    }

    public class InvalidBufferFlagsException
    extends RuntimeException {
        InvalidBufferFlagsException() {
            throw new RuntimeException("Stub!");
        }
    }

    public class IncompatibleWithBlockModelException
    extends RuntimeException {
        IncompatibleWithBlockModelException() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class CryptoInfo {
        public byte[] iv;
        public byte[] key;
        public int mode;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public int numSubSamples;

        public CryptoInfo() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public Pattern getPattern() {
            throw new RuntimeException("Stub!");
        }

        public void set(int newNumSubSamples, @NonNull int[] newNumBytesOfClearData, @NonNull int[] newNumBytesOfEncryptedData, @NonNull byte[] newKey, @NonNull byte[] newIV, int newMode) {
            throw new RuntimeException("Stub!");
        }

        public void setPattern(Pattern newPattern) {
            throw new RuntimeException("Stub!");
        }

        public String toString() {
            throw new RuntimeException("Stub!");
        }

        public static final class Pattern {
            public Pattern(int blocksToEncrypt, int blocksToSkip) {
                throw new RuntimeException("Stub!");
            }

            public int getEncryptBlocks() {
                throw new RuntimeException("Stub!");
            }

            public int getSkipBlocks() {
                throw new RuntimeException("Stub!");
            }

            public void set(int blocksToEncrypt, int blocksToSkip) {
                throw new RuntimeException("Stub!");
            }
        }
    }

    public static final class CryptoException
    extends RuntimeException
    implements MediaDrmThrowable {
        @Deprecated
        public static final int ERROR_FRAME_TOO_LARGE = 8;
        @Deprecated
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        @Deprecated
        public static final int ERROR_INSUFFICIENT_SECURITY = 7;
        @Deprecated
        public static final int ERROR_KEY_EXPIRED = 2;
        @Deprecated
        public static final int ERROR_LOST_STATE = 9;
        @Deprecated
        public static final int ERROR_NO_KEY = 1;
        @Deprecated
        public static final int ERROR_RESOURCE_BUSY = 3;
        @Deprecated
        public static final int ERROR_SESSION_NOT_OPENED = 5;
        @Deprecated
        public static final int ERROR_UNSUPPORTED_OPERATION = 6;

        public CryptoException(int errorCode, @Nullable String detailMessage) {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public CryptoInfo getCryptoInfo() {
            throw new RuntimeException("Stub!");
        }

        public int getErrorCode() {
            throw new RuntimeException("Stub!");
        }

        @Override
        public int getErrorContext() {
            throw new RuntimeException("Stub!");
        }

        @Override
        public int getOemError() {
            throw new RuntimeException("Stub!");
        }

        @Override
        public int getVendorError() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class CodecException
    extends IllegalStateException {
        public static final int ERROR_INSUFFICIENT_RESOURCE = 1100;
        public static final int ERROR_RECLAIMED = 1101;

        CodecException() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public String getDiagnosticInfo() {
            throw new RuntimeException("Stub!");
        }

        public int getErrorCode() {
            throw new RuntimeException("Stub!");
        }

        public boolean isRecoverable() {
            throw new RuntimeException("Stub!");
        }

        public boolean isTransient() {
            throw new RuntimeException("Stub!");
        }
    }

    public static abstract class Callback {
        public Callback() {
            throw new RuntimeException("Stub!");
        }

        public void onCryptoError(@NonNull MediaCodec codec, @NonNull CryptoException e) {
            throw new RuntimeException("Stub!");
        }

        public abstract void onError(@NonNull MediaCodec var1, @NonNull CodecException var2);

        public abstract void onInputBufferAvailable(@NonNull MediaCodec var1, int var2);

        public void onMetricsFlushed(@NonNull MediaCodec codec, @NonNull PersistableBundle metrics) {
            throw new RuntimeException("Stub!");
        }

        public abstract void onOutputBufferAvailable(@NonNull MediaCodec var1, int var2, @NonNull BufferInfo var3);

        public void onOutputBuffersAvailable(@NonNull MediaCodec codec, int index, @NonNull ArrayDeque<BufferInfo> infos) {
            throw new RuntimeException("Stub!");
        }

        public abstract void onOutputFormatChanged(@NonNull MediaCodec var1, @NonNull MediaFormat var2);
    }

    public static final class BufferInfo {
        public int flags;
        public int offset;
        public long presentationTimeUs;
        public int size;

        public BufferInfo() {
            throw new RuntimeException("Stub!");
        }

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            throw new RuntimeException("Stub!");
        }
    }
}

