/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.http.HeaderBlock;
import android.net.http.HttpException;
import android.net.http.UrlResponseInfo;
import java.nio.ByteBuffer;

public abstract class BidirectionalStream {
    public static final int STREAM_PRIORITY_HIGHEST = 4;
    public static final int STREAM_PRIORITY_IDLE = 0;
    public static final int STREAM_PRIORITY_LOW = 2;
    public static final int STREAM_PRIORITY_LOWEST = 1;
    public static final int STREAM_PRIORITY_MEDIUM = 3;

    public BidirectionalStream() {
        throw new RuntimeException("Stub!");
    }

    public abstract void cancel();

    public abstract void flush();

    @NonNull
    public abstract HeaderBlock getHeaders();

    @NonNull
    public abstract String getHttpMethod();

    public abstract int getPriority();

    public abstract int getTrafficStatsTag();

    public abstract int getTrafficStatsUid();

    public abstract boolean hasTrafficStatsTag();

    public abstract boolean hasTrafficStatsUid();

    public abstract boolean isDelayRequestHeadersUntilFirstFlushEnabled();

    public abstract boolean isDone();

    public abstract void read(@NonNull ByteBuffer var1);

    public abstract void start();

    public abstract void write(@NonNull ByteBuffer var1, boolean var2);

    public static interface Callback {
        public void onCanceled(@NonNull BidirectionalStream var1, @Nullable UrlResponseInfo var2);

        public void onFailed(@NonNull BidirectionalStream var1, @Nullable UrlResponseInfo var2, @NonNull HttpException var3);

        public void onReadCompleted(@NonNull BidirectionalStream var1, @NonNull UrlResponseInfo var2, @NonNull ByteBuffer var3, boolean var4);

        public void onResponseHeadersReceived(@NonNull BidirectionalStream var1, @NonNull UrlResponseInfo var2);

        public void onResponseTrailersReceived(@NonNull BidirectionalStream var1, @NonNull UrlResponseInfo var2, @NonNull HeaderBlock var3);

        public void onStreamReady(@NonNull BidirectionalStream var1);

        public void onSucceeded(@NonNull BidirectionalStream var1, @NonNull UrlResponseInfo var2);

        public void onWriteCompleted(@NonNull BidirectionalStream var1, @NonNull UrlResponseInfo var2, @NonNull ByteBuffer var3, boolean var4);
    }

    public static abstract class Builder {
        public Builder() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public abstract Builder addHeader(@NonNull String var1, @NonNull String var2);

        @NonNull
        public abstract BidirectionalStream build();

        @NonNull
        public abstract Builder setDelayRequestHeadersUntilFirstFlushEnabled(boolean var1);

        @NonNull
        public abstract Builder setHttpMethod(@NonNull String var1);

        @NonNull
        public abstract Builder setPriority(int var1);

        @NonNull
        public abstract Builder setTrafficStatsTag(int var1);

        @NonNull
        public abstract Builder setTrafficStatsUid(int var1);
    }
}

