/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;

/**
 * Contains the configuration of the ad selection process that select a winner from a given list of
 * ad selection ids.
 *
 * <p>Instances of this class are created by SDKs to be provided as arguments to the {@link android.adservices.adselection.AdSelectionManager#selectAds  } methods in {@link android.adservices.adselection.AdSelectionManager AdSelectionManager}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdSelectionFromOutcomesConfig implements android.os.Parcelable {

AdSelectionFromOutcomesConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return a list of ad selection ids passed by the SSP to participate in the ad selection from
 *     outcomes process

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.Long> getAdSelectionIds() { throw new RuntimeException("Stub!"); }

/**
 * @return the URI used to retrieve the JS code containing the seller/SSP {@code selectOutcome}
 *     function used during the ad selection

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getSelectionLogicUri() { throw new RuntimeException("Stub!"); }

/**
 * @return JSON in an {@link android.adservices.common.AdSelectionSignals AdSelectionSignals} object, fetched from the {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} and consumed by the JS logic fetched from the DSP {@code
 *     SelectionLogicUri}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdSelectionSignals getSelectionSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return a AdTechIdentifier of the seller, for example "www.example-ssp.com"
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getSeller() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.AdSelectionFromOutcomesConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder for {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} objects. All fields require non-null values
 * to build.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionFromOutcomesConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of {@code AdSelectionIds} to participate in the selection process.
 * @param adSelectionIds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionFromOutcomesConfig.Builder setAdSelectionIds(@android.annotation.NonNull java.util.List<java.lang.Long> adSelectionIds) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@code SelectionLogicUri}. Selection URI could be either of the two schemas:
 *
 * <ul>
 *   <li><b>HTTPS:</b> HTTPS URIs have to be absolute URIs where the host matches the {@code
 *       seller}
 *   <li><b>Ad Selection Prebuilt:</b> Ad Selection Service URIs follow {@code
 *       ad-selection-prebuilt://ad-selection-from-outcomes/<name>?<script-generation-parameters>}
 *       format. FLEDGE generates the appropriate JS script without the need for a network
 *       call.
 *       <p>Available prebuilt scripts:
 *       <ul>
 *         <li><b>{@code waterfall-mediation-truncation} for {@code selectOutcome}:</b> This
 *             JS implements Waterfall mediation truncation logic. Mediation SDK's ad is
 *             returned if its bid greater than or equal to the bid floor. Below
 *             parameter(s) are required to use this prebuilt:
 *             <ul>
 *               <li><b>{@code bidFloor}:</b> Key of the bid floor value passed in the
 *                   {@link android.adservices.adselection.AdSelectionFromOutcomesConfig#getSelectionSignals() AdSelectionFromOutcomesConfig.getSelectionSignals()} that will
 *                   be compared against mediation SDK's winner ad.
 *             </ul>
 *             <p>Ex. If your selection signals look like {@code {"bid_floor": 10}} then,
 *             {@code
 *             ad-selection-prebuilt://ad-selection-from-outcomes/waterfall-mediation-truncation/?bidFloor=bid_floor}
 *       </ul>
 * </ul>
 *
 * {@code AdSelectionIds} and {@code SelectionSignals}.
 
 * @param selectionLogicUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionFromOutcomesConfig.Builder setSelectionLogicUri(@android.annotation.NonNull android.net.Uri selectionLogicUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@code SelectionSignals} to be consumed by the JS script downloaded from {@code
 * SelectionLogicUri}
 
 * @param selectionSignals This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionFromOutcomesConfig.Builder setSelectionSignals(@android.annotation.NonNull android.adservices.common.AdSelectionSignals selectionSignals) { throw new RuntimeException("Stub!"); }

/**
 * Sets the seller {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 * @param seller This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionFromOutcomesConfig.Builder setSeller(@android.annotation.NonNull android.adservices.common.AdTechIdentifier seller) { throw new RuntimeException("Stub!"); }
}

}

