/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.appsetid;


/**
 * A unique, per-device, per developer-account user-resettable ID for non-monetizing advertising
 * usecases.
 *
 * <p>Represents the appSetID and scope of this appSetId from the {@link android.adservices.appsetid.AppSetIdManager#getAppSetId(Executor,OutcomeReceiver)  } API. The scope of the ID can be per app
 * or per developer account associated with the user. AppSetId is used for analytics, spam
 * detection, frequency capping and fraud prevention use cases, on a given device, that one may need
 * to correlate usage or actions across a set of apps owned by an organization.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AppSetId {

/**
 * Creates an instance of {@link android.adservices.appsetid.AppSetId AppSetId}
 *
 * @param appSetId generated by the provider service.
 * This value cannot be {@code null}.
 * @param appSetIdScope scope of the appSetId.

 * Value is {@link android.adservices.appsetid.AppSetId#SCOPE_APP}, or {@link android.adservices.appsetid.AppSetId#SCOPE_DEVELOPER}
 */

public AppSetId(@android.annotation.NonNull java.lang.String appSetId, int appSetIdScope) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the appSetId. The api always returns a non-empty appSetId.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the scope of the appSetId.
 * @return Value is {@link android.adservices.appsetid.AppSetId#SCOPE_APP}, or {@link android.adservices.appsetid.AppSetId#SCOPE_DEVELOPER}
 */

public int getScope() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** The appSetId is scoped to an app. All apps on a device will have a different appSetId. */

public static final int SCOPE_APP = 1; // 0x1

/**
 * The appSetId is scoped to a developer account on an app store. All apps from the same
 * developer on a device will have the same developer scoped appSetId.
 */

public static final int SCOPE_DEVELOPER = 2; // 0x2
}

