/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;


/**
 * A container class for filters which are associated with an ad.
 *
 * <p>If any of the filters in an {@link android.adservices.common.AdFilters AdFilters} instance are not satisfied, the associated ad
 * will not be eligible for ad selection. Filters are optional ad parameters and are not required as
 * part of {@link android.adservices.common.AdData AdData}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdFilters implements android.os.Parcelable {

AdFilters() { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Checks whether the {@link android.adservices.common.AdFilters AdFilters} objects represent the same set of filters. */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Gets the {@link android.adservices.common.AppInstallFilters AppInstallFilters} instance that represents all app install filters for the
 * ad.
 *
 * <p>If {@code null}, there are no app install filters which apply to the ad.
 */

@android.annotation.Nullable
public android.adservices.common.AppInstallFilters getAppInstallFilters() { throw new RuntimeException("Stub!"); }

/**
 * Gets the {@link android.adservices.common.FrequencyCapFilters FrequencyCapFilters} instance that represents all frequency cap filters for
 * the ad.
 *
 * <p>If {@code null}, there are no frequency cap filters which apply to the ad.
 */

@android.annotation.Nullable
public android.adservices.common.FrequencyCapFilters getFrequencyCapFilters() { throw new RuntimeException("Stub!"); }

/** Returns the hash of the {@link android.adservices.common.AdFilters AdFilters} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.AdFilters> CREATOR;
static { CREATOR = null; }
/** Builder for creating {@link android.adservices.common.AdFilters AdFilters} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns an {@link android.adservices.common.AdFilters AdFilters} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdFilters build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.adservices.common.AppInstallFilters AppInstallFilters} which will apply to the ad.
 *
 * <p>If set to {@code null} or not set, no app install filters will be associated with the
 * ad.

 * @param appInstallFilters This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdFilters.Builder setAppInstallFilters(@android.annotation.Nullable android.adservices.common.AppInstallFilters appInstallFilters) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.adservices.common.FrequencyCapFilters FrequencyCapFilters} which will apply to the ad.
 *
 * <p>If set to {@code null} or not set, no frequency cap filters will be associated with
 * the ad.

 * @param frequencyCapFilters This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdFilters.Builder setFrequencyCapFilters(@android.annotation.Nullable android.adservices.common.FrequencyCapFilters frequencyCapFilters) { throw new RuntimeException("Stub!"); }
}

}

