/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;

import android.adservices.adselection.ReportImpressionRequest;
import android.adservices.adselection.UpdateAdCounterHistogramRequest;
import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * A container for the ad filters that are based on frequency caps.
 *
 * <p>No more than 20 frequency cap filters may be associated with a single ad.
 *
 * <p>Frequency caps filters combine an event type with a list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects
 * to define a collection of ad filters. If any of these frequency caps are exceeded for a given ad,
 * the ad will be removed from the group of ads submitted to a buyer adtech's bidding function.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FrequencyCapFilters implements android.os.Parcelable {

FrequencyCapFilters() { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Checks whether the {@link android.adservices.common.FrequencyCapFilters FrequencyCapFilters} objects contain the same information. */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_CLICK} event type.
 *
 * <p>These frequency caps apply to events which correlate to a click as interpreted by an
 * adtech. Click events are counted when the {@link
 * android.adservices.adselection.AdSelectionManager#updateAdCounterHistogram(
 * UpdateAdCounterHistogramRequest, Executor, OutcomeReceiver)} API is invoked with the {@link
 * #AD_EVENT_TYPE_CLICK} event type.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.common.KeyedFrequencyCap> getKeyedFrequencyCapsForClickEvents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_IMPRESSION} event type.
 *
 * <p>These frequency caps apply to events which correlate to an impression as interpreted by an
 * adtech.
 *
 * <p>Note that events are not automatically counted when calling {@link
 * android.adservices.adselection.AdSelectionManager#reportImpression(ReportImpressionRequest,
 * Executor, OutcomeReceiver)}. Instead, the {@link #AD_EVENT_TYPE_IMPRESSION} event type must
 * be updated using the {@link
 * android.adservices.adselection.AdSelectionManager#updateAdCounterHistogram(
 * UpdateAdCounterHistogramRequest, Executor, OutcomeReceiver)} API.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.common.KeyedFrequencyCap> getKeyedFrequencyCapsForImpressionEvents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_VIEW} event type.
 *
 * <p>These frequency caps apply to events which correlate to a view as interpreted by an
 * adtech. View events are counted when the {@link
 * android.adservices.adselection.AdSelectionManager#updateAdCounterHistogram(
 * UpdateAdCounterHistogramRequest, Executor, OutcomeReceiver)} API is invoked with the {@link
 * #AD_EVENT_TYPE_VIEW} event type.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.common.KeyedFrequencyCap> getKeyedFrequencyCapsForViewEvents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_WIN} event type.
 *
 * <p>These frequency caps apply to events for ads that were selected as winners in ad
 * selection. Winning ads are used to automatically increment the associated counter keys on the
 * win event type.
 *
 * <p>Note that the {@link #AD_EVENT_TYPE_WIN} event type cannot be updated manually using the
 * {@link android.adservices.adselection.AdSelectionManager#updateAdCounterHistogram(
 * UpdateAdCounterHistogramRequest, Executor, OutcomeReceiver)} API.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.common.KeyedFrequencyCap> getKeyedFrequencyCapsForWinEvents() { throw new RuntimeException("Stub!"); }

/** Returns the hash of the {@link android.adservices.common.FrequencyCapFilters FrequencyCapFilters} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int AD_EVENT_TYPE_CLICK = 3; // 0x3

public static final int AD_EVENT_TYPE_IMPRESSION = 1; // 0x1

public static final int AD_EVENT_TYPE_VIEW = 2; // 0x2

/**
 * The WIN ad event type is automatically populated within the Protected Audience service for
 * any winning ad which is returned from Protected Audience ad selection.
 *
 * <p>It should not be used to manually update an ad counter histogram.
 */

public static final int AD_EVENT_TYPE_WIN = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.FrequencyCapFilters> CREATOR;
static { CREATOR = null; }
/** Builder for creating {@link android.adservices.common.FrequencyCapFilters FrequencyCapFilters} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a {@link android.adservices.common.FrequencyCapFilters FrequencyCapFilters} instance.
 *
 * <p>No more than 20 frequency cap filters may be associated with a single ad. If more
 * total filters than the limit have been set, an {@link java.lang.IllegalArgumentException IllegalArgumentException} will be
 * thrown.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.FrequencyCapFilters build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_CLICK} event type.
 *
 * <p>See {@link #getKeyedFrequencyCapsForClickEvents()} for more information.
 
 * @param keyedFrequencyCapsForClickEvents This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.FrequencyCapFilters.Builder setKeyedFrequencyCapsForClickEvents(@android.annotation.NonNull java.util.List<android.adservices.common.KeyedFrequencyCap> keyedFrequencyCapsForClickEvents) { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_IMPRESSION} event type.
 *
 * <p>See {@link #getKeyedFrequencyCapsForImpressionEvents()} for more information.
 
 * @param keyedFrequencyCapsForImpressionEvents This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.FrequencyCapFilters.Builder setKeyedFrequencyCapsForImpressionEvents(@android.annotation.NonNull java.util.List<android.adservices.common.KeyedFrequencyCap> keyedFrequencyCapsForImpressionEvents) { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_VIEW} event type.
 *
 * <p>See {@link #getKeyedFrequencyCapsForViewEvents()} for more information.
 
 * @param keyedFrequencyCapsForViewEvents This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.FrequencyCapFilters.Builder setKeyedFrequencyCapsForViewEvents(@android.annotation.NonNull java.util.List<android.adservices.common.KeyedFrequencyCap> keyedFrequencyCapsForViewEvents) { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of {@link android.adservices.common.KeyedFrequencyCap KeyedFrequencyCap} objects that will filter on the {@link
 * #AD_EVENT_TYPE_WIN} event type.
 *
 * <p>See {@link #getKeyedFrequencyCapsForWinEvents()} for more information.
 
 * @param keyedFrequencyCapsForWinEvents This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.FrequencyCapFilters.Builder setKeyedFrequencyCapsForWinEvents(@android.annotation.NonNull java.util.List<android.adservices.common.KeyedFrequencyCap> keyedFrequencyCapsForWinEvents) { throw new RuntimeException("Stub!"); }
}

}

