/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;


/**
 * Represents data used during the ad selection process to fetch buyer bidding signals from a
 * trusted key/value server. The fetched data is used during the ad selection process and consumed
 * by buyer JavaScript logic running in an isolated execution environment.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TrustedBiddingData implements android.os.Parcelable {

TrustedBiddingData() { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} if two {@link android.adservices.customaudience.TrustedBiddingData TrustedBiddingData} objects contain the same information
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return the list of keys to query from the trusted key-value server holding bidding signals

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getTrustedBiddingKeys() { throw new RuntimeException("Stub!"); }

/**
 * @return the URI pointing to the trusted key-value server holding bidding signals. The URI
 *     must use HTTPS.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getTrustedBiddingUri() { throw new RuntimeException("Stub!"); }

/**
 * @return the hash of the {@link android.adservices.customaudience.TrustedBiddingData TrustedBiddingData} object's data
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.customaudience.TrustedBiddingData> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.customaudience.TrustedBiddingData TrustedBiddingData} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.adservices.customaudience.TrustedBiddingData TrustedBiddingData} object.
 *
 * @throws java.lang.NullPointerException if any parameters are null when built

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.TrustedBiddingData build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of keys to query the trusted key-value server with.
 * <p>
 * This list is permitted to be empty, but it must not be null.

 * @param trustedBiddingKeys This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.TrustedBiddingData.Builder setTrustedBiddingKeys(@android.annotation.NonNull java.util.List<java.lang.String> trustedBiddingKeys) { throw new RuntimeException("Stub!"); }

/**
 * Sets the URI pointing to a trusted key-value server used to fetch bidding signals during
 * the ad selection process. The URI must use HTTPS.
 
 * @param trustedBiddingUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.TrustedBiddingData.Builder setTrustedBiddingUri(@android.annotation.NonNull android.net.Uri trustedBiddingUri) { throw new RuntimeException("Stub!"); }
}

}

