/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * A class that an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} can use to signal a failure in handling a request and
 * return an error to be logged and aggregated. The error is not reported to the app that invoked
 * the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} in order to prevent data leakage from the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} to
 * an app. The platform does not interpret the error code, it only logs and aggregates it.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IsolatedServiceException extends java.lang.Exception {

/**
 * Creates an {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException} with an error code to be logged. The meaning of
 * the error code is defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The platform does not interpret
 * the error code.
 *
 * @param errorCode An error code defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 */

public IsolatedServiceException(int errorCode) { throw new RuntimeException("Stub!"); }

/**
 * Creates an {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException} with an error code to be logged. The meaning of
 * the error code is defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The platform does not interpret
 * the error code.
 *
 * @param errorCode An error code defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 * @param message the exception message.
 * This value may be {@code null}.
 * @param cause the cause of this exception.

 * This value may be {@code null}.
 */

public IsolatedServiceException(int errorCode, @android.annotation.Nullable java.lang.String message, @android.annotation.Nullable java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Creates an {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException} with an error code to be logged. The meaning of
 * the error code is defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The platform does not interpret
 * the error code.
 *
 * @param errorCode An error code defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 * @param cause the cause of this exception.

 * This value may be {@code null}.
 */

public IsolatedServiceException(int errorCode, @android.annotation.Nullable java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Returns the error code for this exception.
 */

public int getErrorCode() { throw new RuntimeException("Stub!"); }
}

