/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.os.OutcomeReceiver;

/**
 * Interface with methods that need to be implemented to handle requests from the
 * OnDevicePersonalization service to an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}
 * creates an instance of {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker} on each request and calls one of the methods
 * below, depending the type of the request. The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} calls the method on a
 * Binder thread and the {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker} should offload long running operations to a
 * worker thread. The {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker} should use the {@code receiver} parameter of each
 * method to return results. If any of these methods throws a {@link java.lang.RuntimeException RuntimeException}, the
 * platform treats it as an unrecoverable error in the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} and ends processing
 * the request.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface IsolatedWorker {

/**
 * Handles a completed download. The platform downloads content using the parameters defined in
 * the package manifest of the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}, calls this function after the download
 * is complete, and updates the REMOTE_DATA table from
 * {@link android.adservices.ondevicepersonalization.IsolatedService#getRemoteData(android.adservices.ondevicepersonalization.RequestToken) IsolatedService.getRemoteData(RequestToken)} with the result of this method.
 *
 * @param input Download handler parameters.
 * This value cannot be {@code null}.
 * @param receiver Callback that receives the result {@link android.adservices.ondevicepersonalization.DownloadCompletedOutput DownloadCompletedOutput} or an
 *     {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}.
 *     <p>If this method returns a {@code null} result or exception via the callback, or
 *     throws a {@link java.lang.RuntimeException RuntimeException}, no updates are made to the REMOTE_DATA table.
 */

public default void onDownloadCompleted(@android.annotation.NonNull android.adservices.ondevicepersonalization.DownloadCompletedInput input, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.DownloadCompletedOutput,android.adservices.ondevicepersonalization.IsolatedServiceException> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Handles an event triggered by a request to a platform-provided tracking URL {@link android.adservices.ondevicepersonalization.EventUrlProvider EventUrlProvider} that was embedded in the HTML output returned by
 * {@link #onRender(android.adservices.ondevicepersonalization.RenderInput,android.os.OutcomeReceiver)}. The platform updates the EVENTS table with
 * {@link android.adservices.ondevicepersonalization.EventOutput#getEventLogRecord() EventOutput.getEventLogRecord()}.
 *
 * @param input The parameters needed to compute event data.
 * This value cannot be {@code null}.
 * @param receiver Callback that receives the result {@link android.adservices.ondevicepersonalization.EventOutput EventOutput} or an
 *     {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}.
 *     <p>If this method returns a {@code null} result or exception via the callback, or
 *     throws a {@link java.lang.RuntimeException RuntimeException}, no data is written to the EVENTS table.
 */

public default void onEvent(@android.annotation.NonNull android.adservices.ondevicepersonalization.EventInput input, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.EventOutput,android.adservices.ondevicepersonalization.IsolatedServiceException> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Handles a request from an app. This method is called when an app calls {@code
 * OnDevicePersonalizationManager#execute(ComponentName, PersistableBundle,
 * java.util.concurrent.Executor, OutcomeReceiver)} that refers to a named
 * {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 *
 * @param input Request Parameters from the calling app.
 * This value cannot be {@code null}.
 * @param receiver Callback that receives the result {@link android.adservices.ondevicepersonalization.ExecuteOutput ExecuteOutput} or an
 *     {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}. If this method throws a {@link java.lang.RuntimeException RuntimeException} or
 *     returns either {@code null} or {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}, the error is indicated
 *     to the calling app as an {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException OnDevicePersonalizationException} with error code
 *     {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_FAILED OnDevicePersonalizationException.ERROR_ISOLATED_SERVICE_FAILED}. To avoid leaking
 *     private data to the calling app, more detailed errors are not reported to the caller.
 *     If the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} needs to report additional data beyond the error code to
 *     its backend servers, it should populate the logging fields in {@link android.adservices.ondevicepersonalization.ExecuteOutput ExecuteOutput} with
 *     the additional error data for logging, and rely on Federated Analytics for the stats.
 */

public default void onExecute(@android.annotation.NonNull android.adservices.ondevicepersonalization.ExecuteInput input, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.ExecuteOutput,android.adservices.ondevicepersonalization.IsolatedServiceException> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Generates HTML for the results that were returned as a result of
 * {@link #onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver)}. Called when a client app calls
 * {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager#requestSurfacePackage(android.adservices.ondevicepersonalization.SurfacePackageToken,IBinder,int,int,int,java.util.concurrent.Executor,android.os.OutcomeReceiver) OnDevicePersonalizationManager.requestSurfacePackage(SurfacePackageToken, IBinder, int, int, int, java.util.concurrent.Executor, OutcomeReceiver)}.
 * The platform will render this HTML in an {@link android.webkit.WebView} inside a fenced
 * frame.
 *
 * @param input Parameters for the render request.
 * This value cannot be {@code null}.
 * @param receiver Callback that receives the result {@link android.adservices.ondevicepersonalization.RenderOutput RenderOutput} or an
 *     {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}.
 *     <p>If this method returns a {@code null} result or exception via the callback, or
 *     throws a {@link java.lang.RuntimeException RuntimeException}, the error is also reported to calling
 *     apps as an {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException OnDevicePersonalizationException} with error code {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_FAILED      }.
 */

public default void onRender(@android.annotation.NonNull android.adservices.ondevicepersonalization.RenderInput input, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.RenderOutput,android.adservices.ondevicepersonalization.IsolatedServiceException> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Generate a list of training examples used for federated compute job. The platform will call
 * this function when a federated compute job starts. The federated compute job is scheduled by
 * an app through {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler#schedule FederatedComputeScheduler.schedule}.
 *
 * @param input The parameters needed to generate the training example.
 * This value cannot be {@code null}.
 * @param receiver Callback that receives the result {@link android.adservices.ondevicepersonalization.TrainingExamplesOutput TrainingExamplesOutput} or an
 *     {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}.
 *     <p>If this method returns a {@code null} result or exception via the callback, or
 *     throws a {@link java.lang.RuntimeException RuntimeException}, no training examples is produced for this
 *     training session.
 */

public default void onTrainingExamples(@android.annotation.NonNull android.adservices.ondevicepersonalization.TrainingExamplesInput input, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.TrainingExamplesOutput,android.adservices.ondevicepersonalization.IsolatedServiceException> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Handles a Web Trigger event from a browser. A Web Trigger event occurs when a browser
 * registers a web trigger event with the OS using the <a href="https://github.com/WICG/attribution-reporting-api">
 * Attribution and Reporting API</a>. If the data in the web trigger payload indicates that the
 * event should be forwarded to an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}, the platform will call this function
 * with the web trigger data.
 *
 * @param input The parameters needed to process Web Trigger event.
 * This value cannot be {@code null}.
 * @param receiver Callback that receives the result {@link android.adservices.ondevicepersonalization.WebTriggerOutput WebTriggerOutput} or an
 *     {@link android.adservices.ondevicepersonalization.IsolatedServiceException IsolatedServiceException}. Should be called with a
 *     {@link android.adservices.ondevicepersonalization.WebTriggerOutput WebTriggerOutput} object populated with a set of records to be written to the
 *     REQUESTS or EVENTS tables.
 *     <p>If this method returns a {@code null} result or exception via the callback, or
 *     throws a {@link java.lang.RuntimeException RuntimeException}, no data is written to the REQUESTS orEVENTS tables.
 */

public default void onWebTrigger(@android.annotation.NonNull android.adservices.ondevicepersonalization.WebTriggerInput input, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.WebTriggerOutput,android.adservices.ondevicepersonalization.IsolatedServiceException> receiver) { throw new RuntimeException("Stub!"); }
}

