/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import java.util.concurrent.Executor;

/**
 * Handles model inference and only support TFLite model inference now. See {@link android.adservices.ondevicepersonalization.IsolatedService#getModelManager  }.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ModelManager {

ModelManager() { throw new RuntimeException("Stub!"); }

/**
 * Run a single model inference. Only supports TFLite model inference now.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param input contains all the information needed for a run of model inference.
 * This value cannot be {@code null}.
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param receiver this returns a {@link android.adservices.ondevicepersonalization.InferenceOutput InferenceOutput} which contains model inference result
 *     or {@link java.lang.Exception Exception} on failure.

 * This value cannot be {@code null}.
 */

public void run(@android.annotation.NonNull android.adservices.ondevicepersonalization.InferenceInput input, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.ondevicepersonalization.InferenceOutput,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

