/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.signals;

import android.net.Uri;

/**
 * The request object for updateSignals.
 *
 * <p>{@code updateUri} is the only parameter. It represents the URI that the service will reach out
 * to retrieve the signals updates.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UpdateSignalsRequest {

UpdateSignalsRequest() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} if and only if the other object is {@link android.adservices.signals.UpdateSignalsRequest UpdateSignalsRequest} with the
 *     same update URI.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return the {@link android.net.Uri Uri} from which the signal updates will be fetched.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getUpdateUri() { throw new RuntimeException("Stub!"); }

/**
 * @return the hash of the {@link android.adservices.signals.UpdateSignalsRequest UpdateSignalsRequest} object's data.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return a human-readable representation of {@link android.adservices.signals.UpdateSignalsRequest UpdateSignalsRequest}.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.signals.UpdateSignalsRequest UpdateSignalsRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Instantiates a {@link android.adservices.signals.UpdateSignalsRequest.Builder Builder} with the {@link android.net.Uri Uri} from which the signal updates will be
 * fetched.

 * @param updateUri This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.Uri updateUri) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of a {@link android.adservices.signals.UpdateSignalsRequest UpdateSignalsRequest}.
 *
 * @throws java.lang.NullPointerException if any non-null parameter is null.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.signals.UpdateSignalsRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.net.Uri Uri} from which the JSON is to be fetched.
 *
 * <p>See {@link #getUpdateUri()} ()} for details.
 
 * @param updateUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.signals.UpdateSignalsRequest.Builder setUpdateUri(@android.annotation.NonNull android.net.Uri updateUri) { throw new RuntimeException("Stub!"); }
}

}

