/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.appsearch;

import android.os.ParcelFileDescriptor;

/**
 * The response to provide batch operation results of {@link android.app.appsearch.AppSearchSession#openBlobForWrite AppSearchSession.openBlobForWrite}.
 *
 * <p>This class is used to retrieve the result of a batch write operation on a collection of blob
 * handles.
 *
 * <p class="caution">The returned {@link android.os.ParcelFileDescriptor} must be closed after use
 * to avoid resource leaks. Failing to close the descriptor will result in system resource
 * exhaustion, as each open {@link android.os.ParcelFileDescriptor} occupies a limited file
 * descriptor in the system.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class OpenBlobForWriteResponse implements java.io.Closeable, android.os.Parcelable {

/**
 * Creates a {@link android.app.appsearch.OpenBlobForWriteResponse OpenBlobForWriteResponse} with given {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult}.
 * @param result This value cannot be {@code null}.
 */

public OpenBlobForWriteResponse(@android.annotation.NonNull android.app.appsearch.AppSearchBatchResult<android.app.appsearch.AppSearchBlobHandle,android.os.ParcelFileDescriptor> result) { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} object containing the results of the write blob for
 * write operation for each {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle}.
 *
 * @return A {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} maps {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle}s which is a unique
 *     identifier for a specific blob being committed to the outcome of that write operation. If
 *     the operation was successful, the result for that handle is {@link android.os.ParcelFileDescriptor ParcelFileDescriptor};
 *     if there was an error, the result contains an {@link android.app.appsearch.AppSearchResult AppSearchResult} with details of the
 *     failure.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchBatchResult<android.app.appsearch.AppSearchBlobHandle,android.os.ParcelFileDescriptor> getResult() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.OpenBlobForWriteResponse> CREATOR;
static { CREATOR = null; }
}

