/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.appsearch;


/**
 * Results of {@link android.app.appsearch.AppSearchSession#removeBlob AppSearchSession.removeBlob}, containing the outcome of the removal of each
 * handles.
 *
 * <p>This class is used to retrieve the result of a batch removal operation on a collection of blob
 * handles.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RemoveBlobResponse implements android.os.Parcelable {

/**
 * Creates a {@link android.app.appsearch.RemoveBlobResponse RemoveBlobResponse} with given {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult}.
 * @param result This value cannot be {@code null}.
 */

public RemoveBlobResponse(@android.annotation.NonNull android.app.appsearch.AppSearchBatchResult<android.app.appsearch.AppSearchBlobHandle,java.lang.Void> result) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} object containing the results of the removal
 * operation for each {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle}.
 *
 * @return A {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} maps {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle}s which is a unique
 *     identifier for a specific blob being removed to the outcome of that commit. If the
 *     operation was successful, the result for that handle is {@code null}; if there was an
 *     error, the result contains an {@link android.app.appsearch.AppSearchResult AppSearchResult} with details of the failure.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchBatchResult<android.app.appsearch.AppSearchBlobHandle,java.lang.Void> getResult() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.RemoveBlobResponse> CREATOR;
static { CREATOR = null; }
}

