/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * Request to configure the visibility settings of blobs in AppSearch.
 *
 * <p>Used with {@link android.app.appsearch.AppSearchSession#setBlobVisibility AppSearchSession.setBlobVisibility} to specify visibility and display
 * properties for blob namespaces. You can control which blob namespaces are displayed on system UI
 * surfaces and which are accessible based on specific visibility configurations.
 *
 * @see android.app.appsearch.AppSearchSession#openBlobForWrite
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SetBlobVisibilityRequest {

SetBlobVisibilityRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns all the blob namespaces that are opted out of being displayed and visible on any
 * system UI surface.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getNamespacesNotDisplayedBySystem() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of blob namespaces to the set of {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}s that have
 * access to that namespace.
 *
 * <p>All conditions in a single {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} are "AND" relationship. A caller
 * must match all conditions to have the access. All {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}s in the set
 * of a blob namespace are "OR" relationship. A caller could have access if they matches any
 * {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} in the set.
 *
 * <p>This method provides the set of {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} for all blob namespaces.
 *
 * @see android.app.appsearch.SetBlobVisibilityRequest.Builder#addNamespaceVisibleToConfig
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<android.app.appsearch.SchemaVisibilityConfig>> getNamespacesVisibleToConfigs() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.SetBlobVisibilityRequest SetBlobVisibilityRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Specifies that blobs within the given {@code namespace} can be accessed by the caller if
 * they meet the requirements defined in {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}.
 *
 * <p>The requirements in each {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} have an "AND" relationship,
 * meaning that all conditions within a configuration must be met for access. For instance,
 * the caller may need specific permissions and belong to a specific package.
 *
 * <p>Repeated calls to this method can add multiple {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}s to a
 * namespace. The caller will have access if they match any of the configurations added, so
 * the configurations form an "OR" relationship.
 *
 * @param namespace The blob namespace to set visibility for.
 * @param visibilityConfig The config hold specifying visibility settings.
 */

@android.annotation.NonNull
public android.app.appsearch.SetBlobVisibilityRequest.Builder addNamespaceVisibleToConfig(@android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull android.app.appsearch.SchemaVisibilityConfig visibilityConfig) { throw new RuntimeException("Stub!"); }

/** Builds a new {@link android.app.appsearch.SetBlobVisibilityRequest SetBlobVisibilityRequest} object. */

@android.annotation.NonNull
public android.app.appsearch.SetBlobVisibilityRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Clears all visibility configurations for the specified blob {@code namespace}.
 *
 * <p>After calling this method, the specified namespace will have no visibility
 * configurations, meaning it will only be accessible by default rules.
 *
 * @param namespace The blob namespace for which visibility config should be cleared.
 */

@android.annotation.NonNull
public android.app.appsearch.SetBlobVisibilityRequest.Builder clearNamespaceVisibleToConfigs(@android.annotation.NonNull java.lang.String namespace) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether or not blobs in the specified {@code namespace} will be displayed on any
 * system UI surface.
 *
 * <p>This setting applies to the provided {@code namespace} only, all other {@code
 * namespace}s that are not included here will be reverted to the default displayed setting.
 *
 * <p>If this method is not called, the default behavior allows blobs to be displayed on
 * system UI surfaces.
 *
 * @param namespace The name of the namespace to configure visibility for.
 * @param displayed If {@code false}, blobs in this namespace will not appear on system UI
 *     surfaces.
 */

@android.annotation.NonNull
public android.app.appsearch.SetBlobVisibilityRequest.Builder setNamespaceDisplayedBySystem(@android.annotation.NonNull java.lang.String namespace, boolean displayed) { throw new RuntimeException("Stub!"); }
}

}

