/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

import android.os.Build;

/**
 * This class provides the public APIs to control the Bluetooth A2DP profile.
 *
 * <p>BluetoothA2dp is a proxy object for controlling the Bluetooth A2DP Service via IPC. Use {@link android.bluetooth.BluetoothAdapter#getProfileProxy  } to get the BluetoothA2dp proxy object.
 *
 * <p>Android only supports one connected Bluetooth A2dp device at a time. Each method is protected
 * with its appropriate permission.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothA2dp implements android.bluetooth.BluetoothProfile {

BluetoothA2dp() { throw new RuntimeException("Stub!"); }

public void finalize() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES.S} or or higher, this requires the
 * {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission.BLUETOOTH_CONNECT} permission which can be gained with {@link
 * android.app.Activity#requestPermissions(String[], int)}.

 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 */

public java.util.List<android.bluetooth.BluetoothDevice> getConnectedDevices() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES.S} or or higher, this requires the
 * {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission.BLUETOOTH_CONNECT} permission which can be gained with {@link
 * android.app.Activity#requestPermissions(String[], int)}.
 
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}

 * @return Value is {@link android.bluetooth.BluetoothProfile#STATE_DISCONNECTED}, {@link android.bluetooth.BluetoothProfile#STATE_CONNECTING}, {@link android.bluetooth.BluetoothProfile#STATE_CONNECTED}, or {@link android.bluetooth.BluetoothProfile#STATE_DISCONNECTING}
 */

public int getConnectionState(android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES.S} or or higher, this requires the
 * {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission.BLUETOOTH_CONNECT} permission which can be gained with {@link
 * android.app.Activity#requestPermissions(String[], int)}.

 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 */

public java.util.List<android.bluetooth.BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of source codecs that are supported by the current platform.
 *
 * <p>The list always includes the mandatory SBC codec, and may include optional proprietary
 * codecs.
 *
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES.R} or lower, this requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission.BLUETOOTH} permission which can be gained with a simple {@code
 * <uses-permission>} manifest tag.
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_PRIVILEGED}
 * @return list of supported source codec types
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Collection<android.bluetooth.BluetoothCodecType> getSupportedCodecTypes() { throw new RuntimeException("Stub!"); }

/**
 * Check if A2DP profile is streaming music.
 *
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES.R} or lower, this requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission.BLUETOOTH} permission which can be gained with a simple {@code
 * <uses-permission>} manifest tag.
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES.S} or or higher, this requires the
 * {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission.BLUETOOTH_CONNECT} permission which can be gained with {@link
 * android.app.Activity#requestPermissions(String[], int)}.
 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 * @param device BluetoothDevice device
 */

public boolean isA2dpPlaying(android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

/**
 * Intent used to broadcast the change in connection state of the A2DP profile.
 *
 * <p>This intent will have 3 extras:
 *
 * <ul>
 *   <li>{@link #EXTRA_STATE} - The current state of the profile.
 *   <li>{@link #EXTRA_PREVIOUS_STATE}- The previous state of the profile.
 *   <li>{@link android.bluetooth.BluetoothDevice#EXTRA_DEVICE BluetoothDevice.EXTRA_DEVICE} - The remote device.
 * </ul>
 *
 * <p>{@link #EXTRA_STATE} or {@link #EXTRA_PREVIOUS_STATE} can be any of {@link
 * #STATE_DISCONNECTED}, {@link #STATE_CONNECTING}, {@link #STATE_CONNECTED}, {@link
 * #STATE_DISCONNECTING}.

 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES.R} or lower, this requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission.BLUETOOTH} permission which can be gained with a simple {@code
 * <uses-permission>} manifest tag.
 
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES.S} or or higher, this requires the
 * {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission.BLUETOOTH_CONNECT} permission which can be gained with {@link
 * android.app.Activity#requestPermissions(String[], int)}.

 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED";

/**
 * Intent used to broadcast the change in the Playing state of the A2DP profile.
 *
 * <p>This intent will have 3 extras:
 *
 * <ul>
 *   <li>{@link #EXTRA_STATE} - The current state of the profile.
 *   <li>{@link #EXTRA_PREVIOUS_STATE}- The previous state of the profile.
 *   <li>{@link android.bluetooth.BluetoothDevice#EXTRA_DEVICE BluetoothDevice.EXTRA_DEVICE} - The remote device.
 * </ul>
 *
 * <p>{@link #EXTRA_STATE} or {@link #EXTRA_PREVIOUS_STATE} can be any of {@link
 * #STATE_PLAYING}, {@link #STATE_NOT_PLAYING},

 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#R Build.VERSION_CODES.R} or lower, this requires the {@link android.Manifest.permission#BLUETOOTH Manifest.permission.BLUETOOTH} permission which can be gained with a simple {@code
 * <uses-permission>} manifest tag.
 
 * <br>
 * For apps targeting {@link android.os.Build.VERSION_CODES#S Build.VERSION_CODES.S} or or higher, this requires the
 * {@link android.Manifest.permission#BLUETOOTH_CONNECT Manifest.permission.BLUETOOTH_CONNECT} permission which can be gained with {@link
 * android.app.Activity#requestPermissions(String[], int)}.

 * <br>
 * Requires {@link android.Manifest.permission#BLUETOOTH_CONNECT}
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED";

/**
 * A2DP sink device is NOT streaming music. This state can be one of {@link #EXTRA_STATE} or
 * {@link #EXTRA_PREVIOUS_STATE} of {@link #ACTION_PLAYING_STATE_CHANGED} intent.
 */

public static final int STATE_NOT_PLAYING = 11; // 0xb

/**
 * A2DP sink device is streaming music. This state can be one of {@link #EXTRA_STATE} or {@link
 * #EXTRA_PREVIOUS_STATE} of {@link #ACTION_PLAYING_STATE_CHANGED} intent.
 */

public static final int STATE_PLAYING = 10; // 0xa
}

