/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;


/**
 * Bluetooth Assigned Numbers.
 *
 * <p>For now we only include Company ID values.
 *
 * @see <a href="https://www.bluetooth.org/technical/assignednumbers/identifiers.htm">The Official
 *     Bluetooth SIG Member Website | Company Identifiers</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class BluetoothAssignedNumbers {

BluetoothAssignedNumbers() { throw new RuntimeException("Stub!"); }

public static final int AAMP_OF_AMERICA = 190; // 0xbe

public static final int ACCEL_SEMICONDUCTOR = 74; // 0x4a

public static final int ACE_SENSOR = 188; // 0xbc

public static final int ADIDAS = 195; // 0xc3

public static final int ADVANCED_PANMOBIL_SYSTEMS = 145; // 0x91

public static final int AIROHA_TECHNOLOGY = 148; // 0x94

public static final int ALCATEL = 36; // 0x24

public static final int ALPWISE = 154; // 0x9a

public static final int AMICCOM_ELECTRONICS = 192; // 0xc0

public static final int APLIX = 189; // 0xbd

public static final int APPLE = 76; // 0x4c

public static final int APT_LICENSING = 79; // 0x4f

public static final int ARCHOS = 207; // 0xcf

public static final int ARP_DEVICES = 168; // 0xa8

public static final int ATHEROS_COMMUNICATIONS = 69; // 0x45

public static final int ATMEL = 19; // 0x13

public static final int AUSTCO_COMMUNICATION_SYSTEMS = 213; // 0xd5

public static final int AUTONET_MOBILE = 127; // 0x7f

public static final int AVAGO = 78; // 0x4e

public static final int AVM_BERLIN = 31; // 0x1f

public static final int A_AND_D_ENGINEERING = 105; // 0x69

public static final int A_AND_R_CAMBRIDGE = 124; // 0x7c

public static final int BANDSPEED = 32; // 0x20

public static final int BAND_XI_INTERNATIONAL = 100; // 0x64

public static final int BDE_TECHNOLOGY = 180; // 0xb4

public static final int BEATS_ELECTRONICS = 204; // 0xcc

public static final int BEAUTIFUL_ENTERPRISE = 108; // 0x6c

public static final int BEKEY = 178; // 0xb2

public static final int BELKIN_INTERNATIONAL = 92; // 0x5c

public static final int BINAURIC = 203; // 0xcb

public static final int BIOSENTRONICS = 219; // 0xdb

public static final int BLUEGIGA = 71; // 0x47

public static final int BLUERADIOS = 133; // 0x85

public static final int BLUETOOTH_SIG = 63; // 0x3f

public static final int BLUETREK_TECHNOLOGIES = 151; // 0x97

public static final int BOSE = 158; // 0x9e

public static final int BRIARTEK = 109; // 0x6d

public static final int BROADCOM = 15; // 0xf

public static final int CAEN_RFID = 170; // 0xaa

public static final int CAMBRIDGE_SILICON_RADIO = 10; // 0xa

public static final int CATC = 52; // 0x34

public static final int CINETIX = 175; // 0xaf

public static final int CLARINOX_TECHNOLOGIES = 179; // 0xb3

public static final int COLORFY = 156; // 0x9c

public static final int COMMIL = 51; // 0x33

public static final int CONEXANT_SYSTEMS = 28; // 0x1c

public static final int CONNECTBLUE = 113; // 0x71

public static final int CONTINENTAL_AUTOMOTIVE = 75; // 0x4b

public static final int CONWISE_TECHNOLOGY = 66; // 0x42

public static final int CREATIVE_TECHNOLOGY = 118; // 0x76

public static final int C_TECHNOLOGIES = 38; // 0x26

public static final int DANLERS = 225; // 0xe1

public static final int DELORME_PUBLISHING_COMPANY = 128; // 0x80

public static final int DEXCOM = 208; // 0xd0

public static final int DIALOG_SEMICONDUCTOR = 210; // 0xd2

public static final int DIGIANSWER = 12; // 0xc

public static final int ECLIPSE = 53; // 0x35

public static final int ECOTEST = 136; // 0x88

public static final int ELGATO_SYSTEMS = 206; // 0xce

public static final int EM_MICROELECTRONIC_MARIN = 90; // 0x5a

public static final int EQUINOX_AG = 134; // 0x86

public static final int ERICSSON_TECHNOLOGY = 0; // 0x0

public static final int EVLUMA = 201; // 0xc9

public static final int FREE2MOVE = 83; // 0x53

public static final int FUNAI_ELECTRIC = 144; // 0x90

public static final int GARMIN_INTERNATIONAL = 135; // 0x87

public static final int GCT_SEMICONDUCTOR = 45; // 0x2d

public static final int GELO = 200; // 0xc8

public static final int GENEQ = 194; // 0xc2

public static final int GENERAL_MOTORS = 104; // 0x68

public static final int GENNUM = 59; // 0x3b

public static final int GEOFORCE = 157; // 0x9d

public static final int GIBSON_GUITARS = 98; // 0x62

public static final int GN_NETCOM = 103; // 0x67

public static final int GN_RESOUND = 137; // 0x89

public static final int GOOGLE = 224; // 0xe0

public static final int GREEN_THROTTLE_GAMES = 172; // 0xac

public static final int GROUP_SENSE = 115; // 0x73

public static final int HANLYNN_TECHNOLOGIES = 123; // 0x7b

public static final int HARMAN_INTERNATIONAL = 87; // 0x57

public static final int HEWLETT_PACKARD = 101; // 0x65

public static final int HITACHI = 41; // 0x29

public static final int HOSIDEN = 221; // 0xdd

public static final int IBM = 3; // 0x3

public static final int INFINEON_TECHNOLOGIES = 9; // 0x9

public static final int INGENIEUR_SYSTEMGRUPPE_ZAHN = 171; // 0xab

public static final int INTEGRATED_SILICON_SOLUTION = 65; // 0x41

public static final int INTEGRATED_SYSTEM_SOLUTION = 57; // 0x39

public static final int INTEL = 2; // 0x2

public static final int INVENTEL = 30; // 0x1e

public static final int IPEXTREME = 61; // 0x3d

public static final int I_TECH_DYNAMIC_GLOBAL_DISTRIBUTION = 153; // 0x99

public static final int JAWBONE = 138; // 0x8a

public static final int JIANGSU_TOPPOWER_AUTOMOTIVE_ELECTRONICS = 155; // 0x9b

public static final int JOHNSON_CONTROLS = 185; // 0xb9

public static final int J_AND_M = 82; // 0x52

public static final int KAWANTECH = 212; // 0xd4

public static final int KC_TECHNOLOGY = 22; // 0x16

public static final int KENSINGTON_COMPUTER_PRODUCTS_GROUP = 160; // 0xa0

public static final int LAIRD_TECHNOLOGIES = 119; // 0x77

public static final int LESSWIRE = 121; // 0x79

public static final int LG_ELECTRONICS = 196; // 0xc4

public static final int LINAK = 164; // 0xa4

public static final int LUCENT = 7; // 0x7

public static final int LUDUS_HELSINKI = 132; // 0x84

public static final int MACRONIX = 44; // 0x2c

public static final int MAGNETI_MARELLI = 169; // 0xa9

public static final int MANSELLA = 33; // 0x21

public static final int MARVELL = 72; // 0x48

public static final int MATSUSHITA_ELECTRIC = 58; // 0x3a

public static final int MC10 = 202; // 0xca

public static final int MEDIATEK = 70; // 0x46

public static final int MESO_INTERNATIONAL = 182; // 0xb6

public static final int META_WATCH = 163; // 0xa3

public static final int MEWTEL_TECHNOLOGY = 47; // 0x2f

public static final int MICOMMAND = 99; // 0x63

public static final int MICROCHIP_TECHNOLOGY = 205; // 0xcd

public static final int MICROSOFT = 6; // 0x6

public static final int MINDTREE = 106; // 0x6a

public static final int MISFIT_WEARABLES = 223; // 0xdf

public static final int MITEL_SEMICONDUCTOR = 16; // 0x10

public static final int MITSUBISHI_ELECTRIC = 20; // 0x14

public static final int MOBILIAN_CORPORATION = 55; // 0x37

public static final int MONSTER = 112; // 0x70

public static final int MOTOROLA = 8; // 0x8

public static final int MSTAR_SEMICONDUCTOR = 122; // 0x7a

public static final int MUZIK = 222; // 0xde

public static final int NEC = 34; // 0x22

public static final int NEC_LIGHTING = 149; // 0x95

public static final int NEWLOGIC = 23; // 0x17

public static final int NIKE = 120; // 0x78

public static final int NINE_SOLUTIONS = 102; // 0x66

public static final int NOKIA_MOBILE_PHONES = 1; // 0x1

public static final int NORDIC_SEMICONDUCTOR = 89; // 0x59

public static final int NORWOOD_SYSTEMS = 46; // 0x2e

public static final int ODM_TECHNOLOGY = 150; // 0x96

public static final int OMEGAWAVE = 174; // 0xae

public static final int ONSET_COMPUTER = 197; // 0xc5

public static final int OPEN_INTERFACE = 39; // 0x27

public static final int OTL_DYNAMICS = 165; // 0xa5

public static final int PANDA_OCEAN = 166; // 0xa6

public static final int PARROT = 67; // 0x43

public static final int PARTHUS_TECHNOLOGIES = 14; // 0xe

public static final int PASSIF_SEMICONDUCTOR = 176; // 0xb0

public static final int PETER_SYSTEMTECHNIK = 173; // 0xad

public static final int PHILIPS_SEMICONDUCTORS = 37; // 0x25

public static final int PLANTRONICS = 85; // 0x55

public static final int POLAR_ELECTRO = 107; // 0x6b

public static final int POLAR_ELECTRO_EUROPE = 209; // 0xd1

public static final int PROCTER_AND_GAMBLE = 220; // 0xdc

public static final int QUALCOMM = 29; // 0x1d

public static final int QUALCOMM_CONNECTED_EXPERIENCES = 216; // 0xd8

public static final int QUALCOMM_INNOVATION_CENTER = 184; // 0xb8

public static final int QUALCOMM_LABS = 140; // 0x8c

public static final int QUALCOMM_TECHNOLOGIES = 215; // 0xd7

public static final int QUINTIC = 142; // 0x8e

public static final int QUUPPA = 199; // 0xc7

public static final int RALINK_TECHNOLOGY = 91; // 0x5b

public static final int RDA_MICROELECTRONICS = 97; // 0x61

public static final int REALTEK_SEMICONDUCTOR = 93; // 0x5d

public static final int RED_M = 50; // 0x32

public static final int RENESAS_TECHNOLOGY = 54; // 0x36

public static final int RESEARCH_IN_MOTION = 60; // 0x3c

public static final int RF_MICRO_DEVICES = 40; // 0x28

public static final int RIVIERAWAVES = 96; // 0x60

public static final int ROHDE_AND_SCHWARZ = 25; // 0x19

public static final int RTX_TELECOM = 21; // 0x15

public static final int SAMSUNG_ELECTRONICS = 117; // 0x75

public static final int SARIS_CYCLING_GROUP = 177; // 0xb1

public static final int SEERS_TECHNOLOGY = 125; // 0x7d

public static final int SEIKO_EPSON = 64; // 0x40

public static final int SELFLY = 198; // 0xc6

public static final int SEMILINK = 226; // 0xe2

public static final int SENNHEISER_COMMUNICATIONS = 130; // 0x82

public static final int SHANGHAI_SUPER_SMART_ELECTRONICS = 114; // 0x72

public static final int SHENZHEN_EXCELSECU_DATA_TECHNOLOGY = 193; // 0xc1

public static final int SIGNIA_TECHNOLOGIES = 27; // 0x1b

public static final int SILICON_WAVE = 11; // 0xb

public static final int SIRF_TECHNOLOGY = 80; // 0x50

public static final int SOCKET_MOBILE = 68; // 0x44

public static final int SONY_ERICSSON = 86; // 0x56

public static final int SOUND_ID = 111; // 0x6f

public static final int SPORTS_TRACKING_TECHNOLOGIES = 126; // 0x7e

public static final int SR_MEDIZINELEKTRONIK = 161; // 0xa1

public static final int STACCATO_COMMUNICATIONS = 77; // 0x4d

public static final int STALMART_TECHNOLOGY = 191; // 0xbf

public static final int STARKEY_LABORATORIES = 186; // 0xba

public static final int STOLLMAN_E_PLUS_V = 143; // 0x8f

public static final int STONESTREET_ONE = 94; // 0x5e

public static final int ST_MICROELECTRONICS = 48; // 0x30

public static final int SUMMIT_DATA_COMMUNICATIONS = 110; // 0x6e

public static final int SUUNTO = 159; // 0x9f

public static final int SWIRL_NETWORKS = 181; // 0xb5

public static final int SYMBOL_TECHNOLOGIES = 42; // 0x2a

public static final int SYNOPSYS = 49; // 0x31

public static final int SYSTEMS_AND_CHIPS = 62; // 0x3e

public static final int S_POWER_ELECTRONICS = 187; // 0xbb

public static final int TAIXINGBANG_TECHNOLOGY = 211; // 0xd3

public static final int TENOVIS = 43; // 0x2b

public static final int TERAX = 56; // 0x38

public static final int TEXAS_INSTRUMENTS = 13; // 0xd

public static final int THINKOPTICS = 146; // 0x92

public static final int THREECOM = 5; // 0x5

public static final int THREE_DIJOY = 84; // 0x54

public static final int THREE_DSP = 73; // 0x49

public static final int TIMEKEEPING_SYSTEMS = 131; // 0x83

public static final int TIMEX_GROUP_USA = 214; // 0xd6

public static final int TOPCORN_POSITIONING_SYSTEMS = 139; // 0x8b

public static final int TOSHIBA = 4; // 0x4

public static final int TRANSILICA = 24; // 0x18

public static final int TRELAB = 183; // 0xb7

public static final int TTPCOM = 26; // 0x1a

public static final int TXTR = 218; // 0xda

public static final int TZERO_TECHNOLOGIES = 81; // 0x51

public static final int UNIVERSAL_ELECTRONICS = 147; // 0x93

public static final int VERTU = 162; // 0xa2

public static final int VISTEON = 167; // 0xa7

public static final int VIZIO = 88; // 0x58

public static final int VOYETRA_TURTLE_BEACH = 217; // 0xd9

public static final int WAVEPLUS_TECHNOLOGY = 35; // 0x23

public static final int WICENTRIC = 95; // 0x5f

public static final int WIDCOMM = 17; // 0x11

public static final int WUXI_VIMICRO = 129; // 0x81

public static final int ZEEVO = 18; // 0x12

public static final int ZER01_TV = 152; // 0x98

public static final int ZOMM = 116; // 0x74

public static final int ZSCAN_SOFTWARE = 141; // 0x8d
}

