/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

import java.util.UUID;

/**
 * Defines parameters for creating Bluetooth server and client socket channels.
 *
 * <p>Used with {@link android.bluetooth.BluetoothAdapter#listenUsingSocketSettings BluetoothAdapter.listenUsingSocketSettings} to create a server socket and
 * {@link android.bluetooth.BluetoothDevice#createUsingSocketSettings BluetoothDevice.createUsingSocketSettings} to create a client socket.
 *
 * @see android.bluetooth.BluetoothAdapter#listenUsingSocketSettings
 * @see android.bluetooth.BluetoothDevice#createUsingSocketSettings
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothSocketSettings {

BluetoothSocketSettings() { throw new RuntimeException("Stub!"); }

/**
 * Returns the L2CAP PSM value used for a BluetoothSocket#TYPE_LE socket.
 * @return Value is between 128 and 255 inclusive
 */

public int getL2capPsm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RFCOMM service name used for a BluetoothSocket#TYPE_RFCOMM socket.
 *
 * <p>Defaults to {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getRfcommServiceName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RFCOMM service UUID used for a BluetoothSocket#TYPE_RFCOMM socket.
 *
 * <p>Defaults to {@code null}.
 */

@android.annotation.Nullable
public java.util.UUID getRfcommUuid() { throw new RuntimeException("Stub!"); }

/**
 * Returns the type of the Bluetooth socket.
 *
 * <p>Defaults to {@code BluetoothSocket#TYPE_RFCOMM}.

 * @return Value is {@link android.bluetooth.BluetoothSocket#TYPE_RFCOMM}, {@link android.bluetooth.BluetoothSocket#TYPE_SCO}, {@link android.bluetooth.BluetoothSocket#TYPE_L2CAP}, or {@link android.bluetooth.BluetoothSocket#TYPE_LE}
 */

public int getSocketType() { throw new RuntimeException("Stub!"); }

/**
 * Checks if authentication is enabled for the Bluetooth socket.
 *
 * <p>Defaults to {@code false}.
 */

public boolean isAuthenticationRequired() { throw new RuntimeException("Stub!"); }

/**
 * Checks if encryption is enabled for the Bluetooth socket.
 *
 * <p>Defaults to {@code false}.
 */

public boolean isEncryptionRequired() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.lang.String String} that describes each BluetoothSocketSettings parameter current value.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.bluetooth.BluetoothSocketSettings BluetoothSocketSettings}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.bluetooth.BluetoothSocketSettings BluetoothSocketSettings} object.
 *
 * @return A new {@link android.bluetooth.BluetoothSocketSettings BluetoothSocketSettings} object with the configured parameters.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException on invalid parameters
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the authentication requirement for the Bluetooth socket.
 *
 * <p>Defaults to {@code false}.
 *
 * @param authenticationRequired {@code true} if authentication is required for this socket,
 *     {@code false} otherwise.
 * @return This builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setAuthenticationRequired(boolean authenticationRequired) { throw new RuntimeException("Stub!"); }

/**
 * Sets the encryption requirement for the Bluetooth socket.
 *
 * <p>Defaults to {@code false}.
 *
 * @param encryptionRequired {@code true} if encryption is required for this socket, {@code
 *     false} otherwise.
 * @return This builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setEncryptionRequired(boolean encryptionRequired) { throw new RuntimeException("Stub!"); }

/**
 * Sets the L2CAP PSM (Protocol/Service Multiplexer) for the Bluetooth socket.
 *
 * <p>This is only used for {@link android.bluetooth.BluetoothSocket#TYPE_LE BluetoothSocket.TYPE_LE} sockets.
 *
 * <p>Valid PSM values for {@link android.bluetooth.BluetoothSocket#TYPE_LE BluetoothSocket.TYPE_LE} sockets is ranging from 128
 * (0x80) to 255 (0xFF).
 *
 * <p>Application using this API is responsible for obtaining protocol/service multiplexer
 * (PSM) value from remote device.
 *
 * @param l2capPsm The L2CAP PSM value.
 * Value is between 128 and 255 inclusive
 * @return This builder.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException If l2cap PSM is not in given range.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setL2capPsm(int l2capPsm) { throw new RuntimeException("Stub!"); }

/**
 * Sets the RFCOMM service name associated with the Bluetooth socket.
 *
 * <p>This name is used to identify the service when a remote device searches for it using
 * SDP.
 *
 * <p>This is only used for {@link android.bluetooth.BluetoothSocket#TYPE_RFCOMM BluetoothSocket.TYPE_RFCOMM} sockets.
 *
 * <p>Defaults to {@code null}.
 *
 * @param rfcommServiceName The RFCOMM service name.
 * This value cannot be {@code null}.
 * @return This builder.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setRfcommServiceName(@android.annotation.NonNull java.lang.String rfcommServiceName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the RFCOMM service UUID associated with the Bluetooth socket.
 *
 * <p>This UUID is used to uniquely identify the service when a remote device searches for
 * it using SDP.
 *
 * <p>This is only used for {@link android.bluetooth.BluetoothSocket#TYPE_RFCOMM BluetoothSocket.TYPE_RFCOMM} sockets.
 *
 * <p>Defaults to {@code null}.
 *
 * @param rfcommUuid The RFCOMM service UUID.
 * This value cannot be {@code null}.
 * @return This builder.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setRfcommUuid(@android.annotation.NonNull java.util.UUID rfcommUuid) { throw new RuntimeException("Stub!"); }

/**
 * Sets the socket type.
 *
 * <p>Must be one of:
 *
 * <ul>
 *   <li>{@link android.bluetooth.BluetoothSocket#TYPE_RFCOMM BluetoothSocket.TYPE_RFCOMM}
 *   <li>{@link android.bluetooth.BluetoothSocket#TYPE_LE BluetoothSocket.TYPE_LE}
 * </ul>
 *
 * <p>Defaults to {@code BluetoothSocket#TYPE_RFCOMM}.
 *
 * @param socketType The type of socket.
 * Value is {@link android.bluetooth.BluetoothSocket#TYPE_RFCOMM}, {@link android.bluetooth.BluetoothSocket#TYPE_SCO}, {@link android.bluetooth.BluetoothSocket#TYPE_L2CAP}, or {@link android.bluetooth.BluetoothSocket#TYPE_LE}
 * @return This builder.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException If {@code socketType} is invalid.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setSocketType(int socketType) { throw new RuntimeException("Stub!"); }
}

}

