/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.devicelock;

import android.Manifest.permission;
import android.content.Context;
import android.content.pm.PackageManager;
import java.util.Map;
import java.util.concurrent.Executor;

/**
 * Manager used to interact with the system device lock service.
 * The device lock feature is used by special applications ('kiosk apps', downloaded and installed
 * by the device lock solution) to lock and unlock a device.
 * A typical use case is a financed device, where the financing entity has the capability to lock
 * the device in case of a missed payment.
 * When a device is locked, only a limited set of interactions with the device is allowed (for
 * example, placing emergency calls).
 * <p>
 * Use {@link android.content.Context#getSystemService(java.lang.String)}
 * with {@link android.content.Context#DEVICE_LOCK_SERVICE Context.DEVICE_LOCK_SERVICE} to create a {@link android.devicelock.DeviceLockManager DeviceLockManager}.
 * </p>
 *

 * <br>
 * Requires the {@link android.content.pm.PackageManager#FEATURE_DEVICE_LOCK PackageManager#FEATURE_DEVICE_LOCK} feature which can be detected using {@link android.content.pm.PackageManager#hasSystemFeature(String) PackageManager.hasSystemFeature(String)}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DeviceLockManager {

DeviceLockManager() { throw new RuntimeException("Stub!"); }

/**
 * Get the device id.
 *
 * <br>
 * Requires {@link android.Manifest.permission#MANAGE_DEVICE_LOCK_STATE}
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback this returns either the {@link android.devicelock.DeviceId DeviceId} or an exception.

 * This value cannot be {@code null}.
 */

public void getDeviceId(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.devicelock.DeviceId,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Get the kiosk app roles and packages.
 *
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback this returns either a {@link java.util.Map Map} of device roles/package names,
 *                 or an exception. The Integer in the map represent the device lock role
 *                 (at this moment, the only supported role is
 *                 {@value #DEVICE_LOCK_ROLE_FINANCING}. The String represents tha package
 *                 name of the kiosk app for that role.

 * This value cannot be {@code null}.
 */

public void getKioskApps(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.util.Map<java.lang.Integer,java.lang.String>,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Check if the device is locked or not.
 *
 * <br>
 * Requires {@link android.Manifest.permission#MANAGE_DEVICE_LOCK_STATE}
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback this returns either the lock status or an exception.

 * This value cannot be {@code null}.
 */

public void isDeviceLocked(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Boolean,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Lock the device.
 *
 * <br>
 * Requires {@link android.Manifest.permission#MANAGE_DEVICE_LOCK_STATE}
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback this returns either success or an exception.

 * This value cannot be {@code null}.
 */

public void lockDevice(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Unlock the device.
 *
 * <br>
 * Requires {@link android.Manifest.permission#MANAGE_DEVICE_LOCK_STATE}
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback this returns either success or an exception.

 * This value cannot be {@code null}.
 */

public void unlockDevice(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Constant representing a financed device role, returned by {@link #getKioskApps}.
 */

public static final int DEVICE_LOCK_ROLE_FINANCING = 0; // 0x0
}

