/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.content;

import android.graphics.RectF;

/**
 * Represents the content associated with a goto link on a page in the PDF document. Goto Link is an
 * internal navigation link which directs the user to a different location within the same pdf
 * document
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PdfPageGotoLinkContent implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.content.PdfPageGotoLinkContent PdfPageGotoLinkContent} using the bounds of the goto link
 * and the destination where it is directing
 *
 * @param bounds      Bounds which envelop the goto link
 * This value cannot be {@code null}.
 * @param destination Destination where the goto link is directing
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException     If bounds or destination is null.
 * @throws java.lang.IllegalArgumentException If the bounds list is empty.
 */

public PdfPageGotoLinkContent(@android.annotation.NonNull java.util.List<android.graphics.RectF> bounds, @android.annotation.NonNull android.graphics.pdf.content.PdfPageGotoLinkContent.Destination destination) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the bounds of a {@link android.graphics.pdf.content.PdfPageGotoLinkContent PdfPageGotoLinkContent} represented as a list of {@link android.graphics.RectF RectF}.
 * Links which are spread across multiple lines will be surrounded by multiple {@link android.graphics.RectF RectF}
 * in order of viewing.
 *
 * <p><strong>Note:</strong> Each {@link android.graphics.RectF RectF} represents a bound of the goto link in a single
 * line and defines the coordinates of its 4 edges (left, top, right and bottom) in
 * points (1/72"). The developer will need to render the highlighter as well as
 * intercept the touch events for functionalities such as clicking the link.
 *
 * @return The bounds of the goto link.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.graphics.RectF> getBounds() { throw new RuntimeException("Stub!"); }

/**
 * Gets the destination {@link android.graphics.pdf.content.PdfPageGotoLinkContent.Destination Destination} of the {@link android.graphics.pdf.content.PdfPageGotoLinkContent PdfPageGotoLinkContent}.
 *
 * @return Destination where goto link is directing the user.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.content.PdfPageGotoLinkContent.Destination getDestination() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.content.PdfPageGotoLinkContent> CREATOR;
static { CREATOR = null; }
/**
 * Represents the content associated with the destination where a goto link is directing
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Destination implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.content.PdfPageGotoLinkContent.Destination Destination} using the page number, x coordinate, and
 * y coordinate of the destination where goto link is directing, and the zoom factor of the
 * page when goto link takes to the destination
 * <p><strong>Note:</strong> Here (0,0) represents top-left corner of the page
 *
 * @param pageNumber  Page number of the goto link Destination
 * @param xCoordinate X coordinate of the goto link Destination in points (1/72")
 * @param yCoordinate Y coordinate of the goto link Destination in points (1/72")
 * @param zoom        Zoom factor {@link android.graphics.pdf.content.PdfPageGotoLinkContent.Destination#getZoom() Destination.getZoom()} of the page when goto link
 *                    takes to the destination
 * @throws java.lang.IllegalArgumentException If pageNumber or either of the coordinates or zoom are
 *                                  less than zero
 */

public Destination(int pageNumber, float xCoordinate, float yCoordinate, float zoom) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the page number of the destination where the {@link android.graphics.pdf.content.PdfPageGotoLinkContent PdfPageGotoLinkContent}
 * is directing.
 *
 * @return page number of the destination where goto link is directing the user.

 * Value is 0 or greater
 */

public int getPageNumber() { throw new RuntimeException("Stub!"); }

/**
 * Gets the x coordinate in points (1/72") of the destination where
 * the {@link android.graphics.pdf.content.PdfPageGotoLinkContent PdfPageGotoLinkContent} is directing.
 * <p><strong>Note:</strong> If underlying pdfium library can't determine the x coordinate,
 * it will be set to 0
 *
 * @return x coordinate of the Destination where the goto link is directing the user.

 * Value is 0.0f or greater
 */

public float getXCoordinate() { throw new RuntimeException("Stub!"); }

/**
 * Gets the y coordinate in points (1/72") of the destination where
 * the {@link android.graphics.pdf.content.PdfPageGotoLinkContent PdfPageGotoLinkContent} is directing.
 * <p><strong>Note:</strong> If underlying pdfium library can't determine the y coordinate,
 * it will be set to 0
 *
 * @return y coordinate of the Destination where the goto link is directing the user.

 * Value is 0.0f or greater
 */

public float getYCoordinate() { throw new RuntimeException("Stub!"); }

/**
 * Gets the zoom factor of the page when the goto link takes to the destination
 * <p><strong>Note:</strong> If there is no zoom value embedded, default value of Zoom
 * will be zero. Otherwise, it will be less than 1.0f in case of zoom out and greater
 * than 1.0f in case of zoom in.
 *
 * @return zoom factor of the page when the goto link takes to the destination

 * Value is 0.0f or greater
 */

public float getZoom() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.content.PdfPageGotoLinkContent.Destination> CREATOR;
static { CREATOR = null; }
}

}

