/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.models.selection;

import android.graphics.Point;
import android.graphics.pdf.content.PdfPageTextContent;

/**
 * Represents one edge of the selected content.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SelectionBoundary implements android.os.Parcelable {

/**
 * Create a new instance of {@link android.graphics.pdf.models.selection.SelectionBoundary SelectionBoundary} if the boundary {@link android.graphics.Point Point} is known.
 * Index defaults to -1.
 *
 * @param point The point of selection boundary.
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException If the point is null.
 */

public SelectionBoundary(@android.annotation.NonNull android.graphics.Point point) { throw new RuntimeException("Stub!"); }

/**
 * <p>
 * Create a new instance of {@link android.graphics.pdf.models.selection.SelectionBoundary SelectionBoundary} if index of boundary is known. The text
 * returned by {@link android.graphics.pdf.content.PdfPageTextContent#getText() PdfPageTextContent.getText()} form a "stream" and inside this "stream"
 * each character has an index.
 * <strong>Note: </strong>Point defaults to {@code null} in this case.
 *
 * @param index index of the selection boundary.
 * @throws java.lang.IllegalArgumentException If the index is negative.
 */

public SelectionBoundary(int index) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the index of the text as determined by the text stream processed. If the value is -1
 * then the {@link #getPoint()} will determine the selection boundary.
 *
 * @return index of the selection boundary.
 */

public int getIndex() { throw new RuntimeException("Stub!"); }

/**
 * Gets whether the direction of selection is right-to-left (rtl) or reverse. The value of isRtl
 * is determined by the underlying native layer using the start and stop boundaries.
 *
 * @return The direction of selection
 */

public boolean getIsRtl() { throw new RuntimeException("Stub!"); }

/**
 * Gets the x, y coordinates of the selection boundary in points (1/72"). These coordinates are
 * represented by a {@link android.graphics.Point Point} . If the value is {@code null} then the {@link #getIndex()}
 * will determine the selection boundary.
 * <p><strong>Note:</strong> Point (0,0) represents the top-left corner of the page
 *
 * @return The point of the selection boundary.
 */

@android.annotation.Nullable
public android.graphics.Point getPoint() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.models.selection.SelectionBoundary> CREATOR;
static { CREATOR = null; }
}

