/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CaptureRequest extends android.hardware.camera2.CameraMetadata<android.hardware.camera2.CaptureRequest.Key<?>> implements android.os.Parcelable {

CaptureRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public <T> T get(android.hardware.camera2.CaptureRequest.Key<T> key) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.hardware.camera2.CaptureRequest.Key<?>> getKeys() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.Object getTag() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean isReprocess() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Boolean> BLACK_LEVEL_LOCK;
static { BLACK_LEVEL_LOCK = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> COLOR_CORRECTION_ABERRATION_MODE;
static { COLOR_CORRECTION_ABERRATION_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> COLOR_CORRECTION_COLOR_TEMPERATURE;
static { COLOR_CORRECTION_COLOR_TEMPERATURE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> COLOR_CORRECTION_COLOR_TINT;
static { COLOR_CORRECTION_COLOR_TINT = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.hardware.camera2.params.RggbChannelVector> COLOR_CORRECTION_GAINS;
static { COLOR_CORRECTION_GAINS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> COLOR_CORRECTION_MODE;
static { COLOR_CORRECTION_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.hardware.camera2.params.ColorSpaceTransform> COLOR_CORRECTION_TRANSFORM;
static { COLOR_CORRECTION_TRANSFORM = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AE_ANTIBANDING_MODE;
static { CONTROL_AE_ANTIBANDING_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AE_EXPOSURE_COMPENSATION;
static { CONTROL_AE_EXPOSURE_COMPENSATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Boolean> CONTROL_AE_LOCK;
static { CONTROL_AE_LOCK = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AE_MODE;
static { CONTROL_AE_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AE_PRECAPTURE_TRIGGER;
static { CONTROL_AE_PRECAPTURE_TRIGGER = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AE_PRIORITY_MODE;
static { CONTROL_AE_PRIORITY_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.hardware.camera2.params.MeteringRectangle[]> CONTROL_AE_REGIONS;
static { CONTROL_AE_REGIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.util.Range<java.lang.Integer>> CONTROL_AE_TARGET_FPS_RANGE;
static { CONTROL_AE_TARGET_FPS_RANGE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AF_MODE;
static { CONTROL_AF_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.hardware.camera2.params.MeteringRectangle[]> CONTROL_AF_REGIONS;
static { CONTROL_AF_REGIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AF_TRIGGER;
static { CONTROL_AF_TRIGGER = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AUTOFRAMING;
static { CONTROL_AUTOFRAMING = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Boolean> CONTROL_AWB_LOCK;
static { CONTROL_AWB_LOCK = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_AWB_MODE;
static { CONTROL_AWB_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.hardware.camera2.params.MeteringRectangle[]> CONTROL_AWB_REGIONS;
static { CONTROL_AWB_REGIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_CAPTURE_INTENT;
static { CONTROL_CAPTURE_INTENT = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_EFFECT_MODE;
static { CONTROL_EFFECT_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Boolean> CONTROL_ENABLE_ZSL;
static { CONTROL_ENABLE_ZSL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_EXTENDED_SCENE_MODE;
static { CONTROL_EXTENDED_SCENE_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_MODE;
static { CONTROL_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_POST_RAW_SENSITIVITY_BOOST;
static { CONTROL_POST_RAW_SENSITIVITY_BOOST = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_SCENE_MODE;
static { CONTROL_SCENE_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_SETTINGS_OVERRIDE;
static { CONTROL_SETTINGS_OVERRIDE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_VIDEO_STABILIZATION_MODE;
static { CONTROL_VIDEO_STABILIZATION_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> CONTROL_ZOOM_METHOD;
static { CONTROL_ZOOM_METHOD = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> CONTROL_ZOOM_RATIO;
static { CONTROL_ZOOM_RATIO = null; }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.hardware.camera2.CaptureRequest> CREATOR;
static { CREATOR = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> DISTORTION_CORRECTION_MODE;
static { DISTORTION_CORRECTION_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> EDGE_MODE;
static { EDGE_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> EXTENSION_STRENGTH;
static { EXTENSION_STRENGTH = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> FLASH_MODE;
static { FLASH_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> FLASH_STRENGTH_LEVEL;
static { FLASH_STRENGTH_LEVEL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> HOT_PIXEL_MODE;
static { HOT_PIXEL_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.location.Location> JPEG_GPS_LOCATION;
static { JPEG_GPS_LOCATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> JPEG_ORIENTATION;
static { JPEG_ORIENTATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Byte> JPEG_QUALITY;
static { JPEG_QUALITY = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Byte> JPEG_THUMBNAIL_QUALITY;
static { JPEG_THUMBNAIL_QUALITY = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.util.Size> JPEG_THUMBNAIL_SIZE;
static { JPEG_THUMBNAIL_SIZE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> LENS_APERTURE;
static { LENS_APERTURE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> LENS_FILTER_DENSITY;
static { LENS_FILTER_DENSITY = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> LENS_FOCAL_LENGTH;
static { LENS_FOCAL_LENGTH = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> LENS_FOCUS_DISTANCE;
static { LENS_FOCUS_DISTANCE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> LENS_OPTICAL_STABILIZATION_MODE;
static { LENS_OPTICAL_STABILIZATION_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> NOISE_REDUCTION_MODE;
static { NOISE_REDUCTION_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> REPROCESS_EFFECTIVE_EXPOSURE_FACTOR;
static { REPROCESS_EFFECTIVE_EXPOSURE_FACTOR = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.graphics.Rect> SCALER_CROP_REGION;
static { SCALER_CROP_REGION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> SCALER_ROTATE_AND_CROP;
static { SCALER_ROTATE_AND_CROP = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Long> SENSOR_EXPOSURE_TIME;
static { SENSOR_EXPOSURE_TIME = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Long> SENSOR_FRAME_DURATION;
static { SENSOR_FRAME_DURATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> SENSOR_PIXEL_MODE;
static { SENSOR_PIXEL_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> SENSOR_SENSITIVITY;
static { SENSOR_SENSITIVITY = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<int[]> SENSOR_TEST_PATTERN_DATA;
static { SENSOR_TEST_PATTERN_DATA = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> SENSOR_TEST_PATTERN_MODE;
static { SENSOR_TEST_PATTERN_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> SHADING_MODE;
static { SHADING_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> STATISTICS_FACE_DETECT_MODE;
static { STATISTICS_FACE_DETECT_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Boolean> STATISTICS_HOT_PIXEL_MAP_MODE;
static { STATISTICS_HOT_PIXEL_MAP_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> STATISTICS_LENS_SHADING_MAP_MODE;
static { STATISTICS_LENS_SHADING_MAP_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> STATISTICS_OIS_DATA_MODE;
static { STATISTICS_OIS_DATA_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<android.hardware.camera2.params.TonemapCurve> TONEMAP_CURVE;
static { TONEMAP_CURVE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Float> TONEMAP_GAMMA;
static { TONEMAP_GAMMA = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> TONEMAP_MODE;
static { TONEMAP_MODE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CaptureRequest.Key<java.lang.Integer> TONEMAP_PRESET_CURVE;
static { TONEMAP_PRESET_CURVE = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

Builder() { throw new RuntimeException("Stub!"); }

public void addTarget(@android.annotation.NonNull android.view.Surface outputTarget) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.camera2.CaptureRequest build() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public <T> T get(android.hardware.camera2.CaptureRequest.Key<T> key) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public <T> T getPhysicalCameraKey(android.hardware.camera2.CaptureRequest.Key<T> key, @android.annotation.NonNull java.lang.String physicalCameraId) { throw new RuntimeException("Stub!"); }

public void removeTarget(@android.annotation.NonNull android.view.Surface outputTarget) { throw new RuntimeException("Stub!"); }

public <T> void set(@android.annotation.NonNull android.hardware.camera2.CaptureRequest.Key<T> key, T value) { throw new RuntimeException("Stub!"); }

public <T> android.hardware.camera2.CaptureRequest.Builder setPhysicalCameraKey(@android.annotation.NonNull android.hardware.camera2.CaptureRequest.Key<T> key, T value, @android.annotation.NonNull java.lang.String physicalCameraId) { throw new RuntimeException("Stub!"); }

public void setTag(@android.annotation.Nullable java.lang.Object tag) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Key<T> {

public Key(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.lang.Class<T> type) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

}

