/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.FhirVersion;

/**
 * A create request for {@link android.health.connect.HealthConnectManager#createMedicalDataSource HealthConnectManager.createMedicalDataSource}.
 *
 * <p>Medical data is represented using the <a href="https://hl7.org/fhir/">Fast Healthcare
 * Interoperability Resources (FHIR)</a> standard.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CreateMedicalDataSourceRequest implements android.os.Parcelable {

CreateMedicalDataSourceRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the display name. For the request to succeed this must be unique per app.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDisplayName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR base URI. For data coming from a FHIR server this is <a
 * href="https://hl7.org/fhir/R4/http.html#root">the base URL</a>.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getFhirBaseUri() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR version. For the request to succeeds this must be a version supported by
 * Health Connect, as documented on the {@link android.health.connect.datatypes.FhirVersion FhirVersion}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirVersion getFhirVersion() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.CreateMedicalDataSourceRequest> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.CreateMedicalDataSourceRequest CreateMedicalDataSourceRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.CreateMedicalDataSourceRequest CreateMedicalDataSourceRequest} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.CreateMedicalDataSourceRequest other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.CreateMedicalDataSourceRequest.Builder CreateMedicalDataSourceRequest.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.CreateMedicalDataSourceRequest.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.CreateMedicalDataSourceRequest.Builder CreateMedicalDataSourceRequest.Builder} instance.
 *
 * @param fhirBaseUri The FHIR base URI of the data source. For data coming from a FHIR
 *     server this should be the <a href="https://hl7.org/fhir/R4/http.html#root">FHIR base
 *     URL</a> (e.g. `https://example.com/fhir`). If the data is generated by an app without
 *     a FHIR URL, this can be populated by a unique and understandable URI defined by the
 *     app (e.g. `myapp://..`) that points to the source of the data. We recommend not to
 *     use a domain name that you don't control. If your app supports <a
 *     href="https://developer.android.com/training/app-links/deep-linking">app deep
 *     linking</a>, this URI would ideally link to the source data. The maximum length for
 *     the URI is 2000 characters.
 * This value cannot be {@code null}.
 * @param displayName The display name that describes the data source. The maximum length
 *     for the display name is 90 characters. This must be unique per app.
 * This value cannot be {@code null}.
 * @param fhirVersion The FHIR version of the medical data that will be linked to this data
 *     source. This has to be a version supported by Health Connect, as documented on the
 *     {@link android.health.connect.datatypes.FhirVersion FhirVersion}.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.Uri fhirBaseUri, @android.annotation.NonNull java.lang.String displayName, @android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.CreateMedicalDataSourceRequest CreateMedicalDataSourceRequest} with the specified
 * parameters.
 *
 * @throws java.lang.IllegalArgumentException if the {@code mFhirBaseUri} or {@code mDisplayName}
 *     exceed the character limits or if the {@code mFhirVersion} is not supported by Health
 *     Connect.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.CreateMedicalDataSourceRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the display name. For the request to succeed this must be unique per app.
 *
 * <p>The display name may not exceed 90 characters.
 
 * @param displayName This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.CreateMedicalDataSourceRequest.Builder setDisplayName(@android.annotation.NonNull java.lang.String displayName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR base URI. For data coming from a FHIR server this should be the <a
 * href="https://hl7.org/fhir/R4/http.html#root">FHIR base URL</a> (e.g.
 * `https://example.com/fhir`).
 *
 * <p>If the data is generated by an app without a FHIR base URL, this can be populated by a
 * URI defined by the app (e.g. `myapp://..`) that should:
 *
 * <ul>
 *   <li>Be a unique and understandable URI.
 *   <li>Point to the source of the data. We recommend not to use a domain name that you
 *       don't control.
 *   <li>Ideally allow linking to the data source if your app supports <a
 *       href="https://developer.android.com/training/app-links/deep-linking">app deep
 *       linking</a> to the data.
 * </ul>
 *
 * <p>The URI may not exceed 2000 characters.
 
 * @param fhirBaseUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.CreateMedicalDataSourceRequest.Builder setFhirBaseUri(@android.annotation.NonNull android.net.Uri fhirBaseUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR version of data from this data source.
 *
 * <p>This has to be a version supported by Health Connect, as documented on the {@link android.health.connect.datatypes.FhirVersion FhirVersion}.
 
 * @param fhirVersion This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.CreateMedicalDataSourceRequest.Builder setFhirVersion(@android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }
}

}

