/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;

/**
 * A delete request for {@link android.health.connect.HealthConnectManager#deleteMedicalResources HealthConnectManager.deleteMedicalResources}.
 *
 * <p>Each field in the request acts as a cumulative filter. So if a set of data sources and a set
 * of types are specified, then only resources which are both from data sources in the given set and
 * of types in the given set are deleted.
 *
 * <p>At least one filter must be specified - you cannot construct a request to say delete
 * everything. And for any given requirement set, it must be a non-empty set (empty means the filter
 * does not exist).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DeleteMedicalResourcesRequest implements android.os.Parcelable {

DeleteMedicalResourcesRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the IDs for the {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} that are being requested to delete.
 *
 * <p>These IDs should come from {@link android.health.connect.HealthConnectManager#createMedicalDataSource HealthConnectManager.createMedicalDataSource}, or other
 * {@link android.health.connect.HealthConnectManager HealthConnectManager} data source methods.
 *
 * <p>If the set is empty it means resources from any data source should be deleted.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getDataSourceIds() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.health.connect.datatypes.MedicalResource MedicalResource} types that should be deleted.
 *
 * <p>If the set is empty it means resources of all types should be deleted.
 
 * @return This value cannot be {@code null}.

 * Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 */

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getMedicalResourceTypes() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.DeleteMedicalResourcesRequest> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.DeleteMedicalResourcesRequest DeleteMedicalResourcesRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Constructs a new {@link android.health.connect.DeleteMedicalResourcesRequest.Builder DeleteMedicalResourcesRequest.Builder} with no filters. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.DeleteMedicalResourcesRequest DeleteMedicalResourcesRequest} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.DeleteMedicalResourcesRequest other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.DeleteMedicalResourcesRequest.Builder DeleteMedicalResourcesRequest.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.DeleteMedicalResourcesRequest.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Adds the data source ID to request to delete. This should be an ID of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}.
 *
 * <p>If the set of data source IDs is empty, it means resources from any data source should
 * be deleted.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID.
 
 * @param dataSourceId This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.DeleteMedicalResourcesRequest.Builder addDataSourceId(@android.annotation.NonNull java.lang.String dataSourceId) { throw new RuntimeException("Stub!"); }

/**
 * Adds the medical resource type to request to delete.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code resourceType} is not supported.
 
 * @param resourceType Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.DeleteMedicalResourcesRequest.Builder addMedicalResourceType(int resourceType) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.DeleteMedicalResourcesRequest DeleteMedicalResourcesRequest} with the specified
 * parameters.
 *
 * @throws java.lang.IllegalArgumentException if no data source IDs or medical resource types have
 *     been added.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.DeleteMedicalResourcesRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Clears all data source IDs.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.DeleteMedicalResourcesRequest.Builder clearDataSourceIds() { throw new RuntimeException("Stub!"); }

/**
 * Clears all medical resource types.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.DeleteMedicalResourcesRequest.Builder clearMedicalResourceTypes() { throw new RuntimeException("Stub!"); }
}

}

