/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect;


/**
 * A page read request with specified {@code pageToken} for {@link android.health.connect.HealthConnectManager#readMedicalResources  }.
 *
 * <p>When making a new initial request with new filters, use {@link android.health.connect.ReadMedicalResourcesInitialRequest ReadMedicalResourcesInitialRequest}.
 *
 * <p>Example usage:
 *
 * <pre>{@code
 * ReadMedicalResourcesInitialRequest initialRequest
 *     = new ReadMedicalResourcesInitialRequest.Builder(...).build();
 * ReadMedicalResourcesResponse response = makeRequest(initialRequest);
 * String pageToken = response.getNextPageToken();
 *
 * while (pageToken != null) {
 *     ReadMedicalResourcesPageRequest pageRequest = new ReadMedicalResourcesPageRequest(pageToken);
 *     response = makeRequest(pageRequest);
 *     pageToken = response.getNextPageToken();
 * }
 * }</pre>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ReadMedicalResourcesPageRequest extends android.health.connect.ReadMedicalResourcesRequest {

ReadMedicalResourcesPageRequest() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the page token to read the requested page.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPageToken() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.ReadMedicalResourcesPageRequest ReadMedicalResourcesPageRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.ReadMedicalResourcesPageRequest ReadMedicalResourcesPageRequest} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.ReadMedicalResourcesPageRequest other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.ReadMedicalResourcesPageRequest.Builder ReadMedicalResourcesPageRequest.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.ReadMedicalResourcesPageRequest.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.ReadMedicalResourcesPageRequest ReadMedicalResourcesPageRequest} instance.
 *
 * @param pageToken The page token to read the requested page of the result, from the
 *     previous {@link android.health.connect.ReadMedicalResourcesResponse#getNextPageToken() ReadMedicalResourcesResponse.getNextPageToken()}.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String pageToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.ReadMedicalResourcesPageRequest ReadMedicalResourcesPageRequest} with the specified
 * parameters.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesPageRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum number of {@code MedicalResource}s to be returned by the read operation.
 *
 * <p>If not set, default to 1000.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code pageSize} is less than 1 or more
 *     than 5000.
 
 * @param pageSize Value is between MINIMUM_PAGE_SIZE and MAXIMUM_PAGE_SIZE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesPageRequest.Builder setPageSize(int pageSize) { throw new RuntimeException("Stub!"); }

/**
 * Sets page token to read the requested page of the result, from the previous {@link android.health.connect.ReadMedicalResourcesResponse#getNextPageToken()  }.
 
 * @param pageToken This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadMedicalResourcesPageRequest.Builder setPageToken(@android.annotation.NonNull java.lang.String pageToken) { throw new RuntimeException("Stub!"); }
}

}

