/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;


/**
 * A base class to represent a read request for {@link android.health.connect.HealthConnectManager#readMedicalResources HealthConnectManager.readMedicalResources}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ReadMedicalResourcesRequest {

ReadMedicalResourcesRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns maximum number of {@code MedicalResource}s to be returned by the read operation if
 * set, 1000 otherwise.

 * @return Value is between MINIMUM_PAGE_SIZE and MAXIMUM_PAGE_SIZE inclusive
 */

public int getPageSize() { throw new RuntimeException("Stub!"); }
}

