/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.Record;

/**
 * Response containing list of Records for {@link android.health.connect.HealthConnectManager#readRecords HealthConnectManager.readRecords}.
 *
 * @param <T> the type of the Record for Read record Response
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ReadRecordsResponse<T extends android.health.connect.datatypes.Record> {

ReadRecordsResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns a page token to read the next page of the result. -1 if there are no more pages
 * available.
 */

public long getNextPageToken() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<T> getRecords() { throw new RuntimeException("Stub!"); }
}

