/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.FhirVersion;
import android.health.connect.datatypes.MedicalDataSource;

/**
 * An upsert request for {@link android.health.connect.HealthConnectManager#upsertMedicalResources HealthConnectManager.upsertMedicalResources}.
 *
 * <p>Medical data is represented using the <a href="https://hl7.org/fhir/">Fast Healthcare
 * Interoperability Resources (FHIR)</a> standard.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UpsertMedicalResourceRequest implements android.os.Parcelable {

UpsertMedicalResourceRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR resource data in JSON representation.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the unique ID of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}, to represent where the
 * {@code data} is coming from.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDataSourceId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR version being used for {@code data}. For the request to succeed this must
 * match the {@link android.health.connect.datatypes.MedicalDataSource#getFhirVersion() MedicalDataSource.getFhirVersion()} FHIR version of the {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} with the provided {@code dataSourceId}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirVersion getFhirVersion() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.UpsertMedicalResourceRequest> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.UpsertMedicalResourceRequest UpsertMedicalResourceRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.UpsertMedicalResourceRequest UpsertMedicalResourceRequest} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.UpsertMedicalResourceRequest other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.UpsertMedicalResourceRequest.Builder UpsertMedicalResourceRequest.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.UpsertMedicalResourceRequest.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.UpsertMedicalResourceRequest.Builder UpsertMedicalResourceRequest.Builder} instance.
 *
 * @param dataSourceId The unique identifier of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource},
 *     representing where the data comes from.
 * This value cannot be {@code null}.
 * @param fhirVersion The {@link android.health.connect.datatypes.FhirVersion FhirVersion} object that represents the FHIR version being
 *     used for {@code data}. This has to match the FHIR version of the {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}.
 * This value cannot be {@code null}.
 * @param data The FHIR resource data in JSON representation.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID.
 */

public Builder(@android.annotation.NonNull java.lang.String dataSourceId, @android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion, @android.annotation.NonNull java.lang.String data) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.UpsertMedicalResourceRequest UpsertMedicalResourceRequest} with the specified
 * parameters.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.UpsertMedicalResourceRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR resource data in JSON format.
 * @param data This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.UpsertMedicalResourceRequest.Builder setData(@android.annotation.NonNull java.lang.String data) { throw new RuntimeException("Stub!"); }

/**
 * Sets the unique ID of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}, to represent where the
 * {@code data} is coming from.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID.
 
 * @param dataSourceId This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.UpsertMedicalResourceRequest.Builder setDataSourceId(@android.annotation.NonNull java.lang.String dataSourceId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR version being used for {@code data}. For the request to succeed this must
 * match the {@link android.health.connect.datatypes.MedicalDataSource#getFhirVersion() MedicalDataSource.getFhirVersion()} FHIR version} of the {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} with the provided {@code dataSourceId}.
 
 * @param fhirVersion This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.UpsertMedicalResourceRequest.Builder setFhirVersion(@android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }
}

}

