/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/** Where on the user's body a temperature measurement was taken from. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BodyTemperatureMeasurementLocation {

BodyTemperatureMeasurementLocation() { throw new RuntimeException("Stub!"); }

/** Armpit (axillary) body temperature measurement. */

public static final int MEASUREMENT_LOCATION_ARMPIT = 1; // 0x1

/** Ear (tympanic) body temperature measurement. */

public static final int MEASUREMENT_LOCATION_EAR = 8; // 0x8

/** Finger body temperature measurement. */

public static final int MEASUREMENT_LOCATION_FINGER = 2; // 0x2

/** Forehead body temperature measurement. */

public static final int MEASUREMENT_LOCATION_FOREHEAD = 3; // 0x3

/** Mouth body temperature measurement. */

public static final int MEASUREMENT_LOCATION_MOUTH = 4; // 0x4

/** Rectum body temperature measurement. */

public static final int MEASUREMENT_LOCATION_RECTUM = 5; // 0x5

/** Temporal artery temperature measurement. */

public static final int MEASUREMENT_LOCATION_TEMPORAL_ARTERY = 6; // 0x6

/** Toe body temperature measurement. */

public static final int MEASUREMENT_LOCATION_TOE = 7; // 0x7

/** Body measurement location unknown */

public static final int MEASUREMENT_LOCATION_UNKNOWN = 0; // 0x0

/** Vaginal body temperature measurement. */

public static final int MEASUREMENT_LOCATION_VAGINA = 10; // 0xa

/** Wrist body temperature measurement. */

public static final int MEASUREMENT_LOCATION_WRIST = 9; // 0x9
}

