/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * A class to capture the FHIR resource data. This is the class used for all supported FHIR resource
 * types, which is a subset of the resource list on <a
 * href="https://build.fhir.org/resourcelist.html">the official FHIR website</a>. The list of
 * supported types will likely expand in future releases.
 *
 * <p>FHIR stands for the <a href="https://hl7.org/fhir/">Fast Healthcare Interoperability Resources
 * </a> standard.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FhirResource implements android.os.Parcelable {

FhirResource() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR resource data in JSON representation.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR resource ID. This is extracted from the "id" field in {@code data}. This is
 * NOT a unique identifier among all {@link android.health.connect.datatypes.FhirResource FhirResource}s.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR resource type. This is extracted from the "resourceType" field in {@link
 * #getData}.
 *
 * <p>The list of supported types is a subset of the resource list on <a
 * href="https://build.fhir.org/resourcelist.html">the official FHIR website</a>. For a list of
 * supported types, see the {@link android.health.connect.datatypes.FhirResource FhirResource} constants, such as {@link
 * #FHIR_RESOURCE_TYPE_IMMUNIZATION}. Clients should be aware that this list is non exhaustive
 * and may increase in future releases when additional types will need to be handled.

 * @return Value is {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_IMMUNIZATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_OBSERVATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_CONDITION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PROCEDURE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_REQUEST}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PATIENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ENCOUNTER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_LOCATION}, or {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ORGANIZATION}
 */

public int getType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.FhirResource> CREATOR;
static { CREATOR = null; }

/**
 * FHIR resource type for <a
 * href="https://www.hl7.org/fhir/allergyintolerance.html">AllergyIntolerance</a>.
 */

public static final int FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE = 2; // 0x2

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/condition.html">FHIR
 * Condition</a>.
 */

public static final int FHIR_RESOURCE_TYPE_CONDITION = 4; // 0x4

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/encounter.html">FHIR
 * Encounter</a>.
 */

public static final int FHIR_RESOURCE_TYPE_ENCOUNTER = 12; // 0xc

/**
 * FHIR resource type for <a href="https://www.hl7.org/fhir/immunization.html">Immunization</a>.
 */

public static final int FHIR_RESOURCE_TYPE_IMMUNIZATION = 1; // 0x1

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/location.html">FHIR Location</a>.
 */

public static final int FHIR_RESOURCE_TYPE_LOCATION = 13; // 0xd

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/medication.html">FHIR
 * Medication</a>.
 */

public static final int FHIR_RESOURCE_TYPE_MEDICATION = 6; // 0x6

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/medicationrequest.html">FHIR
 * MedicationRequest</a>.
 */

public static final int FHIR_RESOURCE_TYPE_MEDICATION_REQUEST = 7; // 0x7

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/medicationstatement.html">FHIR
 * MedicationStatement</a>.
 */

public static final int FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT = 8; // 0x8

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/observation.html">FHIR
 * Observation</a>.
 */

public static final int FHIR_RESOURCE_TYPE_OBSERVATION = 3; // 0x3

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/organization.html">FHIR
 * Organization</a>.
 */

public static final int FHIR_RESOURCE_TYPE_ORGANIZATION = 14; // 0xe

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/patient.html">FHIR Patient</a>.
 */

public static final int FHIR_RESOURCE_TYPE_PATIENT = 9; // 0x9

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/practitioner.html">FHIR
 * Practitioner</a>.
 */

public static final int FHIR_RESOURCE_TYPE_PRACTITIONER = 10; // 0xa

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/practitionerrole.html">FHIR
 * PractitionerRole</a>.
 */

public static final int FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE = 11; // 0xb

/**
 * FHIR resource type for a <a href="https://www.hl7.org/fhir/procedure.html">FHIR
 * Procedure</a>.
 */

public static final int FHIR_RESOURCE_TYPE_PROCEDURE = 5; // 0x5
/** Builder class for {@link android.health.connect.datatypes.FhirResource FhirResource}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.datatypes.FhirResource FhirResource} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.FhirResource other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.datatypes.FhirResource.Builder FhirResource.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.FhirResource.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.datatypes.FhirResource.Builder FhirResource.Builder} instance.
 *
 * @param type The FHIR resource type extracted from the "resourceType" field in {@code
 *     data}.
 * Value is {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_IMMUNIZATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_OBSERVATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_CONDITION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PROCEDURE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_REQUEST}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PATIENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ENCOUNTER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_LOCATION}, or {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ORGANIZATION}
 * @param id The FHIR resource ID extracted from the "id" field in {@code data}.
 * This value cannot be {@code null}.
 * @param data The FHIR resource data in JSON representation.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided FHIR resource {@code type} is not a
 *     valid supported type.
 */

public Builder(int type, @android.annotation.NonNull java.lang.String id, @android.annotation.NonNull java.lang.String data) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.datatypes.FhirResource FhirResource} with the specified parameters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirResource build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR resource data in JSON representation.
 * @param data This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirResource.Builder setData(@android.annotation.NonNull java.lang.String data) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR resource ID. This is extracted from the "id" field in {@code data}. This is
 * NOT a unique identifier among all {@link android.health.connect.datatypes.FhirResource FhirResource}s.
 
 * @param id This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirResource.Builder setId(@android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR resource type. This is extracted from the "resourceType" field in {@code
 * data}.
 *
 * @throws java.lang.IllegalArgumentException if the provided FHIR resource {@code type} is not a
 *     valid supported type.
 
 * @param type Value is {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_IMMUNIZATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_OBSERVATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_CONDITION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PROCEDURE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_REQUEST}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PATIENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ENCOUNTER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_LOCATION}, or {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ORGANIZATION}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirResource.Builder setType(int type) { throw new RuntimeException("Stub!"); }
}

}

