/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

import android.os.Parcel;

/**
 * Represents the FHIR version. This is designed according to <a
 * href="https://build.fhir.org/versions.html#versions">the official FHIR versions</a> of the Fast
 * Healthcare Interoperability Resources (FHIR) standard. "label", which represents a 'working'
 * version, is not supported for now.
 *
 * <p>The versions R4 (4.0.1) and R4B (4.3.0) are supported in Health Connect.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FhirVersion implements android.os.Parcelable {

FhirVersion() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Indicates whether some other object is "equal to" this one. */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns the major version. */

public int getMajor() { throw new RuntimeException("Stub!"); }

/** Returns the minor version. */

public int getMinor() { throw new RuntimeException("Stub!"); }

/** Returns the patch version. */

public int getPatch() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Returns {@code true} if the {@link android.health.connect.datatypes.FhirVersion FhirVersion} is supported by Health Connect. */

public boolean isSupportedFhirVersion() { throw new RuntimeException("Stub!"); }

/**
 * Creates a {@link android.health.connect.datatypes.FhirVersion FhirVersion} object with the version of string format.
 *
 * <p>The format should look like "4.0.1" which contains 3 numbers - major, minor and patch,
 * separated by ".". This aligns with <a
 * href="https://build.fhir.org/versions.html#versions">the official FHIR versions</a>. Note
 * that the "label" is not supported for now, which represents a 'working' version.
 
 * @param fhirVersionString This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.health.connect.datatypes.FhirVersion parseFhirVersion(@android.annotation.NonNull java.lang.String fhirVersionString) { throw new RuntimeException("Stub!"); }

/** Returns the string representation of the FHIR version. */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Populates a {@link android.os.Parcel Parcel} with the self information.
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.FhirVersion> CREATOR;
static { CREATOR = null; }
}

