/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;


/**
 * Captures a description of how heavy a user's menstrual flow was (spotting, light, medium, or
 * heavy). Each record represents a description of how heavy the user's menstrual bleeding was.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MenstruationFlowRecord extends android.health.connect.datatypes.InstantRecord {

MenstruationFlowRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return menstruation flow
 */

public int getFlow() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.MenstruationFlowRecord MenstruationFlowRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param flow How heavy the user's menstrual flow was. Optional field. Allowed values:
 *     {@link android.health.connect.datatypes.MenstruationFlowRecord.MenstruationFlowType MenstruationFlowType}.

 * Value is {@link android.health.connect.datatypes.MenstruationFlowRecord.MenstruationFlowType#FLOW_UNKNOWN}, {@link android.health.connect.datatypes.MenstruationFlowRecord.MenstruationFlowType#FLOW_LIGHT}, {@link android.health.connect.datatypes.MenstruationFlowRecord.MenstruationFlowType#FLOW_MEDIUM}, or {@link android.health.connect.datatypes.MenstruationFlowRecord.MenstruationFlowType#FLOW_HEAVY}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int flow) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.MenstruationFlowRecord MenstruationFlowRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MenstruationFlowRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MenstruationFlowRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MenstruationFlowRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }
}

/** Identifier for Menstruation Flow */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MenstruationFlowType {

MenstruationFlowType() { throw new RuntimeException("Stub!"); }

public static final int FLOW_HEAVY = 3; // 0x3

public static final int FLOW_LIGHT = 1; // 0x1

public static final int FLOW_MEDIUM = 2; // 0x2

public static final int FLOW_UNKNOWN = 0; // 0x0
}

}

