/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Mass;

/** Captures what nutrients were consumed as part of a meal or a food item. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class NutritionRecord extends android.health.connect.datatypes.IntervalRecord {

NutritionRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return biotin in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getBiotin() { throw new RuntimeException("Stub!"); }

/**
 * @return caffeine in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getCaffeine() { throw new RuntimeException("Stub!"); }

/**
 * @return calcium in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getCalcium() { throw new RuntimeException("Stub!"); }

/**
 * @return chloride in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getChloride() { throw new RuntimeException("Stub!"); }

/**
 * @return cholesterol in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getCholesterol() { throw new RuntimeException("Stub!"); }

/**
 * @return chromium in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getChromium() { throw new RuntimeException("Stub!"); }

/**
 * @return copper in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getCopper() { throw new RuntimeException("Stub!"); }

/**
 * @return dietaryFiber in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getDietaryFiber() { throw new RuntimeException("Stub!"); }

/**
 * @return energy in {@link android.health.connect.datatypes.units.Energy Energy} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Energy getEnergy() { throw new RuntimeException("Stub!"); }

/**
 * @return energyFromFat in {@link android.health.connect.datatypes.units.Energy Energy} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Energy getEnergyFromFat() { throw new RuntimeException("Stub!"); }

/**
 * @return folate in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getFolate() { throw new RuntimeException("Stub!"); }

/**
 * @return folicAcid in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getFolicAcid() { throw new RuntimeException("Stub!"); }

/**
 * @return iodine in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getIodine() { throw new RuntimeException("Stub!"); }

/**
 * @return iron in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getIron() { throw new RuntimeException("Stub!"); }

/**
 * @return magnesium in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getMagnesium() { throw new RuntimeException("Stub!"); }

/**
 * @return manganese in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getManganese() { throw new RuntimeException("Stub!"); }

/**
 * @return the meal name.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getMealName() { throw new RuntimeException("Stub!"); }

/**
 * @return mealType

 * Value is {@link android.health.connect.datatypes.MealType#MEAL_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_BREAKFAST}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_LUNCH}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_DINNER}, or {@link android.health.connect.datatypes.MealType#MEAL_TYPE_SNACK}
 */

public int getMealType() { throw new RuntimeException("Stub!"); }

/**
 * @return molybdenum in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getMolybdenum() { throw new RuntimeException("Stub!"); }

/**
 * @return monounsaturatedFat in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getMonounsaturatedFat() { throw new RuntimeException("Stub!"); }

/**
 * @return niacin in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getNiacin() { throw new RuntimeException("Stub!"); }

/**
 * @return pantothenicAcid in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getPantothenicAcid() { throw new RuntimeException("Stub!"); }

/**
 * @return phosphorus in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getPhosphorus() { throw new RuntimeException("Stub!"); }

/**
 * @return polyunsaturatedFat in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getPolyunsaturatedFat() { throw new RuntimeException("Stub!"); }

/**
 * @return potassium

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getPotassium() { throw new RuntimeException("Stub!"); }

/**
 * @return protein in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getProtein() { throw new RuntimeException("Stub!"); }

/**
 * @return riboflavin in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getRiboflavin() { throw new RuntimeException("Stub!"); }

/**
 * @return saturatedFat in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getSaturatedFat() { throw new RuntimeException("Stub!"); }

/**
 * @return selenium in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getSelenium() { throw new RuntimeException("Stub!"); }

/**
 * @return sodium in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getSodium() { throw new RuntimeException("Stub!"); }

/**
 * @return sugar in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getSugar() { throw new RuntimeException("Stub!"); }

/**
 * @return thiamin

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getThiamin() { throw new RuntimeException("Stub!"); }

/**
 * @return totalCarbohydrate in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getTotalCarbohydrate() { throw new RuntimeException("Stub!"); }

/**
 * @return totalFat in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getTotalFat() { throw new RuntimeException("Stub!"); }

/**
 * @return transFat in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getTransFat() { throw new RuntimeException("Stub!"); }

/**
 * @return unsaturatedFat

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getUnsaturatedFat() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminA in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminA() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminB12 in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminB12() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminB6 in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminB6() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminC in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminC() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminD in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminD() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminE in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminE() { throw new RuntimeException("Stub!"); }

/**
 * @return vitaminK in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getVitaminK() { throw new RuntimeException("Stub!"); }

/**
 * @return zinc in {@link android.health.connect.datatypes.units.Mass Mass} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Mass getZinc() { throw new RuntimeException("Stub!"); }

/**
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to get total biotin using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> BIOTIN_TOTAL;
static { BIOTIN_TOTAL = null; }

/**
 * Metric identifier to get total caffeine using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> CAFFEINE_TOTAL;
static { CAFFEINE_TOTAL = null; }

/**
 * Metric identifier to get total calcium using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> CALCIUM_TOTAL;
static { CALCIUM_TOTAL = null; }

/**
 * Metric identifier to get total chloride using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> CHLORIDE_TOTAL;
static { CHLORIDE_TOTAL = null; }

/**
 * Metric identifier to get total cholesterol using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> CHOLESTEROL_TOTAL;
static { CHOLESTEROL_TOTAL = null; }

/**
 * Metric identifier to get total chromium using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> CHROMIUM_TOTAL;
static { CHROMIUM_TOTAL = null; }

/**
 * Metric identifier to get total copper using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> COPPER_TOTAL;
static { COPPER_TOTAL = null; }

/**
 * Metric identifier to get total dietary fibre using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> DIETARY_FIBER_TOTAL;
static { DIETARY_FIBER_TOTAL = null; }

/**
 * Metric identifier to get total energy from fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Energy> ENERGY_FROM_FAT_TOTAL;
static { ENERGY_FROM_FAT_TOTAL = null; }

/**
 * Metric identifier to get total energy using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Energy> ENERGY_TOTAL;
static { ENERGY_TOTAL = null; }

/**
 * Metric identifier to get total folate using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> FOLATE_TOTAL;
static { FOLATE_TOTAL = null; }

/**
 * Metric identifier to get total folic acid using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> FOLIC_ACID_TOTAL;
static { FOLIC_ACID_TOTAL = null; }

/**
 * Metric identifier to get total iodine using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> IODINE_TOTAL;
static { IODINE_TOTAL = null; }

/** Metric identifier to get total iron using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> IRON_TOTAL;
static { IRON_TOTAL = null; }

/**
 * Metric identifier to get total magnesium using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> MAGNESIUM_TOTAL;
static { MAGNESIUM_TOTAL = null; }

/**
 * Metric identifier to get total manganese using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> MANGANESE_TOTAL;
static { MANGANESE_TOTAL = null; }

/**
 * Metric identifier to get total molybdenum using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> MOLYBDENUM_TOTAL;
static { MOLYBDENUM_TOTAL = null; }

/**
 * Metric identifier to get total monounsaturated fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> MONOUNSATURATED_FAT_TOTAL;
static { MONOUNSATURATED_FAT_TOTAL = null; }

/**
 * Metric identifier to get total niacin using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> NIACIN_TOTAL;
static { NIACIN_TOTAL = null; }

/**
 * Metric identifier to get total pantothenic acid fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> PANTOTHENIC_ACID_TOTAL;
static { PANTOTHENIC_ACID_TOTAL = null; }

/**
 * Metric identifier to get total phosphorus fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> PHOSPHORUS_TOTAL;
static { PHOSPHORUS_TOTAL = null; }

/**
 * Metric identifier to get total polyunsaturated fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> POLYUNSATURATED_FAT_TOTAL;
static { POLYUNSATURATED_FAT_TOTAL = null; }

/**
 * Metric identifier to get total potassium using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> POTASSIUM_TOTAL;
static { POTASSIUM_TOTAL = null; }

/**
 * Metric identifier to get total protein using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> PROTEIN_TOTAL;
static { PROTEIN_TOTAL = null; }

/**
 * Metric identifier to get total riboflavin using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> RIBOFLAVIN_TOTAL;
static { RIBOFLAVIN_TOTAL = null; }

/**
 * Metric identifier to get total saturated fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> SATURATED_FAT_TOTAL;
static { SATURATED_FAT_TOTAL = null; }

/**
 * Metric identifier to get total selenium using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> SELENIUM_TOTAL;
static { SELENIUM_TOTAL = null; }

/**
 * Metric identifier to get total sodium using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> SODIUM_TOTAL;
static { SODIUM_TOTAL = null; }

/** Metric identifier to get total sugar using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> SUGAR_TOTAL;
static { SUGAR_TOTAL = null; }

/**
 * Metric identifier to get total thiamin using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> THIAMIN_TOTAL;
static { THIAMIN_TOTAL = null; }

/**
 * Metric identifier to get total carbohydrate using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> TOTAL_CARBOHYDRATE_TOTAL;
static { TOTAL_CARBOHYDRATE_TOTAL = null; }

/** Metric identifier to get total fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> TOTAL_FAT_TOTAL;
static { TOTAL_FAT_TOTAL = null; }

/**
 * Metric identifier to get total trans fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> TRANS_FAT_TOTAL;
static { TRANS_FAT_TOTAL = null; }

/**
 * Metric identifier to get total unsaturated fat using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> UNSATURATED_FAT_TOTAL;
static { UNSATURATED_FAT_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin A using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_A_TOTAL;
static { VITAMIN_A_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin B12 using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_B12_TOTAL;
static { VITAMIN_B12_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin B6 using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_B6_TOTAL;
static { VITAMIN_B6_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin C using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_C_TOTAL;
static { VITAMIN_C_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin D using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_D_TOTAL;
static { VITAMIN_D_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin E using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_E_TOTAL;
static { VITAMIN_E_TOTAL = null; }

/**
 * Metric identifier to get total Vitamin K using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> VITAMIN_K_TOTAL;
static { VITAMIN_K_TOTAL = null; }

/** Metric identifier to get total Zinc using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Mass> ZINC_TOTAL;
static { ZINC_TOTAL = null; }
/** Builder class for {@link android.health.connect.datatypes.NutritionRecord NutritionRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity
 * This value cannot be {@code null}.
 * @param endTime End time of this activity

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.NutritionRecord NutritionRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the biotin of this activity
 *
 * @param biotin Biotin of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setBiotin(@android.annotation.Nullable android.health.connect.datatypes.units.Mass biotin) { throw new RuntimeException("Stub!"); }

/**
 * Sets the caffeine of this activity
 *
 * @param caffeine Caffeine of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setCaffeine(@android.annotation.Nullable android.health.connect.datatypes.units.Mass caffeine) { throw new RuntimeException("Stub!"); }

/**
 * Sets the calcium of this activity
 *
 * @param calcium Calcium of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setCalcium(@android.annotation.Nullable android.health.connect.datatypes.units.Mass calcium) { throw new RuntimeException("Stub!"); }

/**
 * Sets the chloride of this activity
 *
 * @param chloride Chloride of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setChloride(@android.annotation.Nullable android.health.connect.datatypes.units.Mass chloride) { throw new RuntimeException("Stub!"); }

/**
 * Sets the cholesterol of this activity
 *
 * @param cholesterol Cholesterol of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setCholesterol(@android.annotation.Nullable android.health.connect.datatypes.units.Mass cholesterol) { throw new RuntimeException("Stub!"); }

/**
 * Sets the chromium of this activity
 *
 * @param chromium Chromium of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setChromium(@android.annotation.Nullable android.health.connect.datatypes.units.Mass chromium) { throw new RuntimeException("Stub!"); }

/**
 * Sets the copper of this activity
 *
 * @param copper Copper of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setCopper(@android.annotation.Nullable android.health.connect.datatypes.units.Mass copper) { throw new RuntimeException("Stub!"); }

/**
 * Sets the dietaryFiber of this activity
 *
 * @param dietaryFiber DietaryFiber of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setDietaryFiber(@android.annotation.Nullable android.health.connect.datatypes.units.Mass dietaryFiber) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the energy of this activity
 *
 * @param energy Energy of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setEnergy(@android.annotation.Nullable android.health.connect.datatypes.units.Energy energy) { throw new RuntimeException("Stub!"); }

/**
 * Sets the energyFromFat of this activity
 *
 * @param energyFromFat EnergyFromFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setEnergyFromFat(@android.annotation.Nullable android.health.connect.datatypes.units.Energy energyFromFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the folate of this activity
 *
 * @param folate Folate of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setFolate(@android.annotation.Nullable android.health.connect.datatypes.units.Mass folate) { throw new RuntimeException("Stub!"); }

/**
 * Sets the folicAcid of this activity
 *
 * @param folicAcid FolicAcid of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setFolicAcid(@android.annotation.Nullable android.health.connect.datatypes.units.Mass folicAcid) { throw new RuntimeException("Stub!"); }

/**
 * Sets the iodine of this activity
 *
 * @param iodine Iodine of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setIodine(@android.annotation.Nullable android.health.connect.datatypes.units.Mass iodine) { throw new RuntimeException("Stub!"); }

/**
 * Sets the iron of this activity
 *
 * @param iron Iron of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setIron(@android.annotation.Nullable android.health.connect.datatypes.units.Mass iron) { throw new RuntimeException("Stub!"); }

/**
 * Sets the magnesium of this activity
 *
 * @param magnesium Magnesium of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setMagnesium(@android.annotation.Nullable android.health.connect.datatypes.units.Mass magnesium) { throw new RuntimeException("Stub!"); }

/**
 * Sets the manganese of this activity
 *
 * @param manganese Manganese of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setManganese(@android.annotation.Nullable android.health.connect.datatypes.units.Mass manganese) { throw new RuntimeException("Stub!"); }

/**
 * Sets the name of this activity
 *
 * @param mealName Name of this activity
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setMealName(@android.annotation.NonNull java.lang.String mealName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the mealType of this activity
 *
 * @param mealType MealType of this activity
 
 * Value is {@link android.health.connect.datatypes.MealType#MEAL_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_BREAKFAST}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_LUNCH}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_DINNER}, or {@link android.health.connect.datatypes.MealType#MEAL_TYPE_SNACK}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setMealType(int mealType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the molybdenum of this activity
 *
 * @param molybdenum Molybdenum of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setMolybdenum(@android.annotation.Nullable android.health.connect.datatypes.units.Mass molybdenum) { throw new RuntimeException("Stub!"); }

/**
 * Sets the monounsaturatedFat of this activity
 *
 * @param monounsaturatedFat MonounsaturatedFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setMonounsaturatedFat(@android.annotation.Nullable android.health.connect.datatypes.units.Mass monounsaturatedFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the niacin of this activity
 *
 * @param niacin Niacin of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setNiacin(@android.annotation.Nullable android.health.connect.datatypes.units.Mass niacin) { throw new RuntimeException("Stub!"); }

/**
 * Sets the pantothenicAcid of this activity
 *
 * @param pantothenicAcid PantothenicAcid of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setPantothenicAcid(@android.annotation.Nullable android.health.connect.datatypes.units.Mass pantothenicAcid) { throw new RuntimeException("Stub!"); }

/**
 * Sets the phosphorus of this activity
 *
 * @param phosphorus Phosphorus of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setPhosphorus(@android.annotation.Nullable android.health.connect.datatypes.units.Mass phosphorus) { throw new RuntimeException("Stub!"); }

/**
 * Sets the polyunsaturatedFat of this activity
 *
 * @param polyunsaturatedFat PolyunsaturatedFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setPolyunsaturatedFat(@android.annotation.Nullable android.health.connect.datatypes.units.Mass polyunsaturatedFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the potassium of this activity
 *
 * @param potassium Potassium of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setPotassium(@android.annotation.Nullable android.health.connect.datatypes.units.Mass potassium) { throw new RuntimeException("Stub!"); }

/**
 * Sets the protein of this activity
 *
 * @param protein Protein of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setProtein(@android.annotation.Nullable android.health.connect.datatypes.units.Mass protein) { throw new RuntimeException("Stub!"); }

/**
 * Sets the riboflavin of this activity
 *
 * @param riboflavin Riboflavin of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setRiboflavin(@android.annotation.Nullable android.health.connect.datatypes.units.Mass riboflavin) { throw new RuntimeException("Stub!"); }

/**
 * Sets the saturatedFat of this activity
 *
 * @param saturatedFat SaturatedFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setSaturatedFat(@android.annotation.Nullable android.health.connect.datatypes.units.Mass saturatedFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the selenium of this activity
 *
 * @param selenium Selenium of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setSelenium(@android.annotation.Nullable android.health.connect.datatypes.units.Mass selenium) { throw new RuntimeException("Stub!"); }

/**
 * Sets the sodium of this activity
 *
 * @param sodium Sodium of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setSodium(@android.annotation.Nullable android.health.connect.datatypes.units.Mass sodium) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the sugar of this activity
 *
 * @param sugar Sugar of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setSugar(@android.annotation.Nullable android.health.connect.datatypes.units.Mass sugar) { throw new RuntimeException("Stub!"); }

/**
 * Sets the thiamin of this activity
 *
 * @param thiamin Thiamin of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setThiamin(@android.annotation.Nullable android.health.connect.datatypes.units.Mass thiamin) { throw new RuntimeException("Stub!"); }

/**
 * Sets the totalCarbohydrate of this activity
 *
 * @param totalCarbohydrate TotalCarbohydrate of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setTotalCarbohydrate(@android.annotation.Nullable android.health.connect.datatypes.units.Mass totalCarbohydrate) { throw new RuntimeException("Stub!"); }

/**
 * Sets the totalFat of this activity
 *
 * @param totalFat TotalFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setTotalFat(@android.annotation.Nullable android.health.connect.datatypes.units.Mass totalFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the transFat of this activity
 *
 * @param transFat TransFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setTransFat(@android.annotation.Nullable android.health.connect.datatypes.units.Mass transFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the unsaturatedFat of this activity
 *
 * @param unsaturatedFat UnsaturatedFat of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setUnsaturatedFat(@android.annotation.Nullable android.health.connect.datatypes.units.Mass unsaturatedFat) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminA of this activity
 *
 * @param vitaminA VitaminA of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminA(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminA) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminB12 of this activity
 *
 * @param vitaminB12 VitaminB12 of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminB12(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminB12) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminB6 of this activity
 *
 * @param vitaminB6 VitaminB6 of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminB6(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminB6) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminC of this activity
 *
 * @param vitaminC VitaminC of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminC(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminC) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminD of this activity
 *
 * @param vitaminD VitaminD of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminD(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminD) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminE of this activity
 *
 * @param vitaminE VitaminE of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminE(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminE) { throw new RuntimeException("Stub!"); }

/**
 * Sets the vitaminK of this activity
 *
 * @param vitaminK VitaminK of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setVitaminK(@android.annotation.Nullable android.health.connect.datatypes.units.Mass vitaminK) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zinc of this activity
 *
 * @param zinc Zinc of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.NutritionRecord.Builder setZinc(@android.annotation.Nullable android.health.connect.datatypes.units.Mass zinc) { throw new RuntimeException("Stub!"); }
}

}

