/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;

/**
 * Captures the user's resting heart rate. Each record represents a single instantaneous
 * measurement.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RestingHeartRateRecord extends android.health.connect.datatypes.InstantRecord {

RestingHeartRateRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return beatsPerMinute
 */

public long getBeatsPerMinute() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to get average resting heart rate in beats per minute using aggregate APIs
 * in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> BPM_AVG;
static { BPM_AVG = null; }

/**
 * Metric identifier to get max resting heart rate in beats per minute using aggregate APIs in
 * {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> BPM_MAX;
static { BPM_MAX = null; }

/**
 * Metric identifier to get min resting heart rate in beats per minute using aggregate APIs in
 * {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> BPM_MIN;
static { BPM_MIN = null; }
/** Builder class for {@link android.health.connect.datatypes.RestingHeartRateRecord RestingHeartRateRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param beatsPerMinute Heart beats per minute. Required field. Validation range: 1-300.

 * Value is between 1 and 300 inclusive
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, long beatsPerMinute) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.RestingHeartRateRecord RestingHeartRateRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.RestingHeartRateRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.RestingHeartRateRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.RestingHeartRateRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }
}

}

