/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;


/**
 * A class that contains GNSS Automatic Gain Control (AGC) information.
 *
 * <p> AGC acts as a variable gain amplifier adjusting the power of the incoming signal. The AGC
 * level may be used to indicate potential interference. Higher gain (and/or lower input power)
 * shall be output as a positive number. Hence in cases of strong jamming, in the band of this
 * signal, this value will go more negative. This value must be consistent given the same level
 * of the incoming signal power.
 *
 * <p> Note: Different hardware designs (e.g. antenna, pre-amplification, or other RF HW
 * components) may also affect the typical output of this value on any given hardware design
 * in an open sky test - the important aspect of this output is that changes in this value are
 * indicative of changes on input signal power in the frequency band for this measurement.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssAutomaticGainControl implements android.os.Parcelable {

GnssAutomaticGainControl() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Gets the carrier frequency of the tracked signal.
 *
 * <p>For example it can be the GPS central frequency for L1 = 1575.45 MHz, or L2 = 1227.60 MHz,
 * L5 = 1176.45 MHz, varying GLO channels, etc.
 *
 * @return the carrier frequency of the signal tracked in Hz.

 * Value is 0 or greater
 */

public long getCarrierFrequencyHz() { throw new RuntimeException("Stub!"); }

/**
 * Gets the constellation type.
 *
 * <p>The return value is one of those constants with {@code CONSTELLATION_} prefix in
 * {@link android.location.GnssStatus GnssStatus}.

 * @return Value is {@link android.location.GnssStatus#CONSTELLATION_UNKNOWN}, {@link android.location.GnssStatus#CONSTELLATION_GPS}, {@link android.location.GnssStatus#CONSTELLATION_SBAS}, {@link android.location.GnssStatus#CONSTELLATION_GLONASS}, {@link android.location.GnssStatus#CONSTELLATION_QZSS}, {@link android.location.GnssStatus#CONSTELLATION_BEIDOU}, {@link android.location.GnssStatus#CONSTELLATION_GALILEO}, or {@link android.location.GnssStatus#CONSTELLATION_IRNSS}
 */

public int getConstellationType() { throw new RuntimeException("Stub!"); }

/**
 * Gets the Automatic Gain Control level in dB.

 * @return Value is between -10000 and 10000 inclusive
 */

public double getLevelDb() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flag) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssAutomaticGainControl> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.location.GnssAutomaticGainControl GnssAutomaticGainControl} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a {@link android.location.GnssAutomaticGainControl.Builder GnssAutomaticGainControl.Builder} instance.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a {@link android.location.GnssAutomaticGainControl.Builder GnssAutomaticGainControl.Builder} instance by copying a
 * {@link android.location.GnssAutomaticGainControl GnssAutomaticGainControl}.

 * @param agc This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.GnssAutomaticGainControl agc) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.location.GnssAutomaticGainControl GnssAutomaticGainControl} instance as specified by this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAutomaticGainControl build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the Carrier frequency in Hz.
 
 * @param carrierFrequencyHz Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAutomaticGainControl.Builder setCarrierFrequencyHz(long carrierFrequencyHz) { throw new RuntimeException("Stub!"); }

/**
 * Sets the constellation type.
 
 * @param constellationType Value is {@link android.location.GnssStatus#CONSTELLATION_UNKNOWN}, {@link android.location.GnssStatus#CONSTELLATION_GPS}, {@link android.location.GnssStatus#CONSTELLATION_SBAS}, {@link android.location.GnssStatus#CONSTELLATION_GLONASS}, {@link android.location.GnssStatus#CONSTELLATION_QZSS}, {@link android.location.GnssStatus#CONSTELLATION_BEIDOU}, {@link android.location.GnssStatus#CONSTELLATION_GALILEO}, or {@link android.location.GnssStatus#CONSTELLATION_IRNSS}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAutomaticGainControl.Builder setConstellationType(int constellationType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the Automatic Gain Control level in dB.
 
 * @param levelDb Value is between -10000 and 10000 inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAutomaticGainControl.Builder setLevelDb(double levelDb) { throw new RuntimeException("Stub!"); }
}

}

