/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.media;


/**
 * Provides support for interacting with {@link android.media.MediaSession2 MediaSession2s}
 * that applications have published to express their ongoing media playback state.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MediaCommunicationManager {

MediaCommunicationManager() { throw new RuntimeException("Stub!"); }

/**
 * This API is not generally intended for third party application developers.
 * Use the <a href="{@docRoot}jetpack/androidx.html">AndroidX</a>
 * <a href="{@docRoot}media/media3/session/control-playback">Media3 session
 * Library</a> for consistent behavior across all devices.
 * <p>
 * Gets a list of {@link android.media.Session2Token Session2Token} with type {@link android.media.Session2Token#TYPE_SESSION Session2Token.TYPE_SESSION} for the
 * current user.
 * <p>
 * Although this API can be used without any restriction, each session owners can accept or
 * reject your uses of {@link android.media.MediaSession2 MediaSession2}.
 *
 * @return A list of {@link android.media.Session2Token Session2Token}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.media.Session2Token> getSession2Tokens() { throw new RuntimeException("Stub!"); }

/**
 * Gets the version of this {@link android.media.MediaCommunicationManager MediaCommunicationManager}.

 * @return Value is 1 or greater
 */

public int getVersion() { throw new RuntimeException("Stub!"); }
}

