/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaRoute2Info implements android.os.Parcelable {

MediaRoute2Info() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getClientPackageName() { throw new RuntimeException("Stub!"); }

public int getConnectionState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getDeduplicationIds() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getDescription() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFeatures() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri getIconUri() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getName() { throw new RuntimeException("Stub!"); }

public int getSuitabilityStatus() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public int getVolume() { throw new RuntimeException("Stub!"); }

public int getVolumeHandling() { throw new RuntimeException("Stub!"); }

public int getVolumeMax() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean isSystemRoute() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONNECTION_STATE_CONNECTED = 2; // 0x2

public static final int CONNECTION_STATE_CONNECTING = 1; // 0x1

public static final int CONNECTION_STATE_DISCONNECTED = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.MediaRoute2Info> CREATOR;
static { CREATOR = null; }

public static final java.lang.String FEATURE_LIVE_AUDIO = "android.media.route.feature.LIVE_AUDIO";

public static final java.lang.String FEATURE_LIVE_VIDEO = "android.media.route.feature.LIVE_VIDEO";

public static final java.lang.String FEATURE_REMOTE_AUDIO_PLAYBACK = "android.media.route.feature.REMOTE_AUDIO_PLAYBACK";

public static final java.lang.String FEATURE_REMOTE_PLAYBACK = "android.media.route.feature.REMOTE_PLAYBACK";

public static final java.lang.String FEATURE_REMOTE_VIDEO_PLAYBACK = "android.media.route.feature.REMOTE_VIDEO_PLAYBACK";

public static final int PLAYBACK_VOLUME_FIXED = 0; // 0x0

public static final int PLAYBACK_VOLUME_VARIABLE = 1; // 0x1

public static final int SUITABILITY_STATUS_NOT_SUITABLE_FOR_TRANSFER = 2; // 0x2

public static final int SUITABILITY_STATUS_SUITABLE_FOR_DEFAULT_TRANSFER = 0; // 0x0

public static final int SUITABILITY_STATUS_SUITABLE_FOR_MANUAL_TRANSFER = 1; // 0x1

public static final int TYPE_AUX_LINE = 19; // 0x13

public static final int TYPE_BLE_HEADSET = 26; // 0x1a

public static final int TYPE_BLUETOOTH_A2DP = 8; // 0x8

public static final int TYPE_BUILTIN_SPEAKER = 2; // 0x2

public static final int TYPE_DOCK = 13; // 0xd

public static final int TYPE_GROUP = 2000; // 0x7d0

public static final int TYPE_HDMI = 9; // 0x9

public static final int TYPE_HDMI_ARC = 10; // 0xa

public static final int TYPE_HDMI_EARC = 29; // 0x1d

public static final int TYPE_HEARING_AID = 23; // 0x17

public static final int TYPE_LINE_ANALOG = 5; // 0x5

public static final int TYPE_LINE_DIGITAL = 6; // 0x6

public static final int TYPE_MULTICHANNEL_SPEAKER_GROUP = 32; // 0x20

public static final int TYPE_REMOTE_AUDIO_VIDEO_RECEIVER = 1003; // 0x3eb

public static final int TYPE_REMOTE_CAR = 1008; // 0x3f0

public static final int TYPE_REMOTE_COMPUTER = 1006; // 0x3ee

public static final int TYPE_REMOTE_GAME_CONSOLE = 1007; // 0x3ef

public static final int TYPE_REMOTE_SMARTPHONE = 1010; // 0x3f2

public static final int TYPE_REMOTE_SMARTWATCH = 1009; // 0x3f1

public static final int TYPE_REMOTE_SPEAKER = 1002; // 0x3ea

public static final int TYPE_REMOTE_TABLET = 1004; // 0x3ec

public static final int TYPE_REMOTE_TABLET_DOCKED = 1005; // 0x3ed

public static final int TYPE_REMOTE_TV = 1001; // 0x3e9

public static final int TYPE_UNKNOWN = 0; // 0x0

public static final int TYPE_USB_ACCESSORY = 12; // 0xc

public static final int TYPE_USB_DEVICE = 11; // 0xb

public static final int TYPE_USB_HEADSET = 22; // 0x16

public static final int TYPE_WIRED_HEADPHONES = 4; // 0x4

public static final int TYPE_WIRED_HEADSET = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull android.media.MediaRoute2Info routeInfo) { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull java.lang.String id, @android.annotation.NonNull java.lang.CharSequence name) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder addFeature(@android.annotation.NonNull java.lang.String feature) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder addFeatures(@android.annotation.NonNull java.util.Collection<java.lang.String> features) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder clearFeatures() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setClientPackageName(@android.annotation.Nullable java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setConnectionState(int connectionState) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setDeduplicationIds(@android.annotation.NonNull java.util.Set<java.lang.String> id) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setDescription(@android.annotation.Nullable java.lang.CharSequence description) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setExtras(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setIconUri(@android.annotation.Nullable android.net.Uri iconUri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setSuitabilityStatus(int suitabilityStatus) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setType(int type) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVisibilityPublic() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVisibilityRestricted(@android.annotation.NonNull java.util.Set<java.lang.String> allowedPackages) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVolume(int volume) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVolumeHandling(int volumeHandling) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVolumeMax(int volumeMax) { throw new RuntimeException("Stub!"); }
}

}

