/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.media.metrics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EditingEndedEvent extends android.media.metrics.Event implements android.os.Parcelable {

EditingEndedEvent() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getExporterName() { throw new RuntimeException("Stub!"); }

public float getFinalProgressPercent() { throw new RuntimeException("Stub!"); }

public int getFinalState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.metrics.MediaItemInfo> getInputMediaItemInfos() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getMetricsBundle() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getMuxerName() { throw new RuntimeException("Stub!"); }

public long getOperationTypes() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.metrics.MediaItemInfo getOutputMediaItemInfo() { throw new RuntimeException("Stub!"); }

public long getTimeSinceCreatedMillis() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.metrics.EditingEndedEvent> CREATOR;
static { CREATOR = null; }

public static final int ERROR_CODE_AUDIO_PROCESSING_FAILED = 18; // 0x12

public static final int ERROR_CODE_DECODER_INIT_FAILED = 11; // 0xb

public static final int ERROR_CODE_DECODING_FAILED = 12; // 0xc

public static final int ERROR_CODE_DECODING_FORMAT_UNSUPPORTED = 13; // 0xd

public static final int ERROR_CODE_ENCODER_INIT_FAILED = 14; // 0xe

public static final int ERROR_CODE_ENCODING_FAILED = 15; // 0xf

public static final int ERROR_CODE_ENCODING_FORMAT_UNSUPPORTED = 16; // 0x10

public static final int ERROR_CODE_FAILED_RUNTIME_CHECK = 2; // 0x2

public static final int ERROR_CODE_IO_BAD_HTTP_STATUS = 6; // 0x6

public static final int ERROR_CODE_IO_CLEARTEXT_NOT_PERMITTED = 9; // 0x9

public static final int ERROR_CODE_IO_FILE_NOT_FOUND = 7; // 0x7

public static final int ERROR_CODE_IO_NETWORK_CONNECTION_FAILED = 4; // 0x4

public static final int ERROR_CODE_IO_NETWORK_CONNECTION_TIMEOUT = 5; // 0x5

public static final int ERROR_CODE_IO_NO_PERMISSION = 8; // 0x8

public static final int ERROR_CODE_IO_READ_POSITION_OUT_OF_RANGE = 10; // 0xa

public static final int ERROR_CODE_IO_UNSPECIFIED = 3; // 0x3

public static final int ERROR_CODE_MUXING_FAILED = 19; // 0x13

public static final int ERROR_CODE_NONE = 1; // 0x1

public static final int ERROR_CODE_VIDEO_FRAME_PROCESSING_FAILED = 17; // 0x11

public static final int FINAL_STATE_CANCELED = 2; // 0x2

public static final int FINAL_STATE_ERROR = 3; // 0x3

public static final int FINAL_STATE_SUCCEEDED = 1; // 0x1

public static final long OPERATION_TYPE_AUDIO_EDIT = 8L; // 0x8L

public static final long OPERATION_TYPE_AUDIO_TRANSCODE = 2L; // 0x2L

public static final long OPERATION_TYPE_AUDIO_TRANSMUX = 32L; // 0x20L

public static final long OPERATION_TYPE_PAUSED = 64L; // 0x40L

public static final long OPERATION_TYPE_RESUMED = 128L; // 0x80L

public static final long OPERATION_TYPE_VIDEO_EDIT = 4L; // 0x4L

public static final long OPERATION_TYPE_VIDEO_TRANSCODE = 1L; // 0x1L

public static final long OPERATION_TYPE_VIDEO_TRANSMUX = 16L; // 0x10L

public static final int PROGRESS_PERCENT_UNKNOWN = -1; // 0xffffffff

public static final int TIME_SINCE_CREATED_UNKNOWN = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(int finalState) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder addInputMediaItemInfo(@android.annotation.NonNull android.media.metrics.MediaItemInfo mediaItemInfo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder addOperationType(long operationType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setErrorCode(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setExporterName(@android.annotation.NonNull java.lang.String exporterName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setFinalProgressPercent(float finalProgressPercent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setMetricsBundle(@android.annotation.NonNull android.os.Bundle metricsBundle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setMuxerName(@android.annotation.NonNull java.lang.String muxerName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setOutputMediaItemInfo(@android.annotation.NonNull android.media.metrics.MediaItemInfo mediaItemInfo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.EditingEndedEvent.Builder setTimeSinceCreatedMillis(long timeSinceCreatedMillis) { throw new RuntimeException("Stub!"); }
}

}

