/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.quality;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaQualityManager {

MediaQualityManager() { throw new RuntimeException("Stub!"); }

public void addActiveProcessingPictureListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.util.List<android.media.quality.ActiveProcessingPicture>> listener) { throw new RuntimeException("Stub!"); }

public void createPictureProfile(@android.annotation.NonNull android.media.quality.PictureProfile pp) { throw new RuntimeException("Stub!"); }

public void createSoundProfile(@android.annotation.NonNull android.media.quality.SoundProfile sp) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.quality.PictureProfile> getAvailablePictureProfiles(@android.annotation.Nullable android.media.quality.MediaQualityManager.ProfileQueryParams options) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.quality.SoundProfile> getAvailableSoundProfiles(@android.annotation.Nullable android.media.quality.MediaQualityManager.ProfileQueryParams options) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.quality.ParameterCapability> getParameterCapabilities(@android.annotation.NonNull java.util.List<java.lang.String> names) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.quality.PictureProfile getPictureProfile(int type, @android.annotation.NonNull java.lang.String name, @android.annotation.Nullable android.media.quality.MediaQualityManager.ProfileQueryParams options) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.quality.SoundProfile getSoundProfile(int type, @android.annotation.NonNull java.lang.String name, @android.annotation.Nullable android.media.quality.MediaQualityManager.ProfileQueryParams options) { throw new RuntimeException("Stub!"); }

public boolean isAmbientBacklightEnabled() { throw new RuntimeException("Stub!"); }

public boolean isAutoPictureQualityEnabled() { throw new RuntimeException("Stub!"); }

public boolean isAutoSoundQualityEnabled() { throw new RuntimeException("Stub!"); }

public boolean isSuperResolutionEnabled() { throw new RuntimeException("Stub!"); }

public void registerAmbientBacklightCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.quality.MediaQualityManager.AmbientBacklightCallback callback) { throw new RuntimeException("Stub!"); }

public void registerPictureProfileCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.quality.MediaQualityManager.PictureProfileCallback callback) { throw new RuntimeException("Stub!"); }

public void registerSoundProfileCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.quality.MediaQualityManager.SoundProfileCallback callback) { throw new RuntimeException("Stub!"); }

public void removeActiveProcessingPictureListener(@android.annotation.NonNull java.util.function.Consumer<java.util.List<android.media.quality.ActiveProcessingPicture>> listener) { throw new RuntimeException("Stub!"); }

public void removePictureProfile(@android.annotation.NonNull java.lang.String profileId) { throw new RuntimeException("Stub!"); }

public void removeSoundProfile(@android.annotation.NonNull java.lang.String profileId) { throw new RuntimeException("Stub!"); }

public void setAmbientBacklightEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public void setAmbientBacklightSettings(@android.annotation.NonNull android.media.quality.AmbientBacklightSettings settings) { throw new RuntimeException("Stub!"); }

public void unregisterAmbientBacklightCallback(@android.annotation.NonNull android.media.quality.MediaQualityManager.AmbientBacklightCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterPictureProfileCallback(@android.annotation.NonNull android.media.quality.MediaQualityManager.PictureProfileCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterSoundProfileCallback(@android.annotation.NonNull android.media.quality.MediaQualityManager.SoundProfileCallback callback) { throw new RuntimeException("Stub!"); }

public void updatePictureProfile(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.PictureProfile pp) { throw new RuntimeException("Stub!"); }

public void updateSoundProfile(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.SoundProfile sp) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AmbientBacklightCallback {

public void onAmbientBacklightEvent(@android.annotation.NonNull android.media.quality.AmbientBacklightEvent event);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class PictureProfileCallback {

public PictureProfileCallback() { throw new RuntimeException("Stub!"); }

public void onError(@android.annotation.Nullable java.lang.String profileId, int errorCode) { throw new RuntimeException("Stub!"); }

public void onParameterCapabilitiesChanged(@android.annotation.Nullable java.lang.String profileId, @android.annotation.NonNull java.util.List<android.media.quality.ParameterCapability> updatedCaps) { throw new RuntimeException("Stub!"); }

public void onPictureProfileAdded(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.PictureProfile profile) { throw new RuntimeException("Stub!"); }

public void onPictureProfileRemoved(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.PictureProfile profile) { throw new RuntimeException("Stub!"); }

public void onPictureProfileUpdated(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.PictureProfile profile) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ProfileQueryParams implements android.os.Parcelable {

ProfileQueryParams() { throw new RuntimeException("Stub!"); }

public boolean areParametersIncluded() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.quality.MediaQualityManager.ProfileQueryParams> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.quality.MediaQualityManager.ProfileQueryParams build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.quality.MediaQualityManager.ProfileQueryParams.Builder setParametersIncluded(boolean included) { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class SoundProfileCallback {

public SoundProfileCallback() { throw new RuntimeException("Stub!"); }

public void onError(@android.annotation.Nullable java.lang.String profileId, int errorCode) { throw new RuntimeException("Stub!"); }

public void onParameterCapabilitiesChanged(@android.annotation.Nullable java.lang.String profileId, @android.annotation.NonNull java.util.List<android.media.quality.ParameterCapability> updatedCaps) { throw new RuntimeException("Stub!"); }

public void onSoundProfileAdded(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.SoundProfile profile) { throw new RuntimeException("Stub!"); }

public void onSoundProfileRemoved(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.SoundProfile profile) { throw new RuntimeException("Stub!"); }

public void onSoundProfileUpdated(@android.annotation.NonNull java.lang.String profileId, @android.annotation.NonNull android.media.quality.SoundProfile profile) { throw new RuntimeException("Stub!"); }
}

}

