/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.tv.interactive;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TvInteractiveAppView extends android.view.ViewGroup {

public TvInteractiveAppView(@android.annotation.NonNull android.content.Context context) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

public TvInteractiveAppView(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.util.AttributeSet attrs) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

public TvInteractiveAppView(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.util.AttributeSet attrs, int defStyleAttr) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

public void clearCallback() { throw new RuntimeException("Stub!"); }

public void clearOnUnhandledInputEventListener() { throw new RuntimeException("Stub!"); }

public void createBiInteractiveApp(@android.annotation.NonNull android.net.Uri biIAppUri, @android.annotation.Nullable android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void destroyBiInteractiveApp(@android.annotation.NonNull java.lang.String biIAppId) { throw new RuntimeException("Stub!"); }

public boolean dispatchKeyEvent(@androidx.annotation.RecentlyNonNull android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean dispatchUnhandledInputEvent(@android.annotation.NonNull android.view.InputEvent event) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.tv.interactive.TvInteractiveAppView.OnUnhandledInputEventListener getOnUnhandledInputEventListener() { throw new RuntimeException("Stub!"); }

public void notifyError(@android.annotation.NonNull java.lang.String errMsg, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void notifyRecordingScheduled(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.Nullable java.lang.String requestId) { throw new RuntimeException("Stub!"); }

public void notifyRecordingStarted(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.Nullable java.lang.String requestId) { throw new RuntimeException("Stub!"); }

public void notifyRecordingStopped(@android.annotation.NonNull java.lang.String recordingId) { throw new RuntimeException("Stub!"); }

public void notifyTimeShiftCurrentPositionChanged(@android.annotation.NonNull java.lang.String inputId, long timeMs) { throw new RuntimeException("Stub!"); }

public void notifyTimeShiftPlaybackParams(@android.annotation.NonNull android.media.PlaybackParams params) { throw new RuntimeException("Stub!"); }

public void notifyTimeShiftStartPositionChanged(@android.annotation.NonNull java.lang.String inputId, long timeMs) { throw new RuntimeException("Stub!"); }

public void notifyTimeShiftStatusChanged(@android.annotation.NonNull java.lang.String inputId, int status) { throw new RuntimeException("Stub!"); }

public void notifyTvMessage(@android.annotation.NonNull int type, @android.annotation.NonNull android.os.Bundle data) { throw new RuntimeException("Stub!"); }

public void notifyVideoFreezeUpdated(boolean isFrozen) { throw new RuntimeException("Stub!"); }

public void onAttachedToWindow() { throw new RuntimeException("Stub!"); }

public void onDetachedFromWindow() { throw new RuntimeException("Stub!"); }

public void onLayout(boolean changed, int left, int top, int right, int bottom) { throw new RuntimeException("Stub!"); }

public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) { throw new RuntimeException("Stub!"); }

public boolean onUnhandledInputEvent(@android.annotation.NonNull android.view.InputEvent event) { throw new RuntimeException("Stub!"); }

public void onVisibilityChanged(@android.annotation.NonNull android.view.View changedView, int visibility) { throw new RuntimeException("Stub!"); }

public void prepareInteractiveApp(@android.annotation.NonNull java.lang.String iAppServiceId, int type) { throw new RuntimeException("Stub!"); }

public void reset() { throw new RuntimeException("Stub!"); }

public void resetInteractiveApp() { throw new RuntimeException("Stub!"); }

public void sendAvailableSpeeds(@android.annotation.NonNull float[] speeds) { throw new RuntimeException("Stub!"); }

public void sendCertificate(@android.annotation.NonNull java.lang.String host, int port, @android.annotation.NonNull android.net.http.SslCertificate cert) { throw new RuntimeException("Stub!"); }

public void sendCurrentChannelLcn(int lcn) { throw new RuntimeException("Stub!"); }

public void sendCurrentChannelUri(@android.annotation.Nullable android.net.Uri channelUri) { throw new RuntimeException("Stub!"); }

public void sendCurrentTvInputId(@android.annotation.Nullable java.lang.String inputId) { throw new RuntimeException("Stub!"); }

public void sendCurrentVideoBounds(@android.annotation.NonNull android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

public void sendSelectedTrackInfo(@android.annotation.Nullable java.util.List<android.media.tv.TvTrackInfo> tracks) { throw new RuntimeException("Stub!"); }

public void sendSigningResult(@android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull byte[] result) { throw new RuntimeException("Stub!"); }

public void sendStreamVolume(float volume) { throw new RuntimeException("Stub!"); }

public void sendTimeShiftMode(int mode) { throw new RuntimeException("Stub!"); }

public void sendTrackInfoList(@android.annotation.Nullable java.util.List<android.media.tv.TvTrackInfo> tracks) { throw new RuntimeException("Stub!"); }

public void sendTvRecordingInfo(@android.annotation.Nullable android.media.tv.TvRecordingInfo recordingInfo) { throw new RuntimeException("Stub!"); }

public void sendTvRecordingInfoList(@android.annotation.NonNull java.util.List<android.media.tv.TvRecordingInfo> recordingInfoList) { throw new RuntimeException("Stub!"); }

public void setCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.tv.interactive.TvInteractiveAppView.TvInteractiveAppCallback callback) { throw new RuntimeException("Stub!"); }

public void setOnUnhandledInputEventListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.tv.interactive.TvInteractiveAppView.OnUnhandledInputEventListener listener) { throw new RuntimeException("Stub!"); }

public void setTeletextAppEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public int setTvView(@android.annotation.Nullable android.media.tv.TvView tvView) { throw new RuntimeException("Stub!"); }

public void setZOrderMediaOverlay(boolean isMediaOverlay) { throw new RuntimeException("Stub!"); }

public void setZOrderOnTop(boolean onTop) { throw new RuntimeException("Stub!"); }

public void startInteractiveApp() { throw new RuntimeException("Stub!"); }

public void stopInteractiveApp() { throw new RuntimeException("Stub!"); }

public static final java.lang.String BI_INTERACTIVE_APP_KEY_ALIAS = "alias";

public static final java.lang.String BI_INTERACTIVE_APP_KEY_CERTIFICATE = "certificate";

public static final java.lang.String BI_INTERACTIVE_APP_KEY_HTTP_ADDITIONAL_HEADERS = "http_additional_headers";

public static final java.lang.String BI_INTERACTIVE_APP_KEY_HTTP_USER_AGENT = "http_user_agent";

public static final java.lang.String BI_INTERACTIVE_APP_KEY_PRIVATE_KEY = "private_key";

public static final java.lang.String ERROR_KEY_METHOD_NAME = "method_name";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnUnhandledInputEventListener {

public boolean onUnhandledInputEvent(@android.annotation.NonNull android.view.InputEvent event);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class TvInteractiveAppCallback {

public TvInteractiveAppCallback() { throw new RuntimeException("Stub!"); }

public void onBiInteractiveAppCreated(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull android.net.Uri biIAppUri, @android.annotation.Nullable java.lang.String biIAppId) { throw new RuntimeException("Stub!"); }

public void onPlaybackCommandRequest(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String cmdType, @android.annotation.NonNull android.os.Bundle parameters) { throw new RuntimeException("Stub!"); }

public void onRequestAvailableSpeeds(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestCertificate(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String host, int port) { throw new RuntimeException("Stub!"); }

public void onRequestCurrentChannelLcn(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestCurrentChannelUri(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestCurrentTvInputId(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestCurrentVideoBounds(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestScheduleRecording(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String requestId, @android.annotation.NonNull java.lang.String inputId, @android.annotation.NonNull android.net.Uri channelUri, @android.annotation.NonNull android.net.Uri programUri, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void onRequestScheduleRecording(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String requestId, @android.annotation.NonNull java.lang.String inputId, @android.annotation.NonNull android.net.Uri channelUri, long startTime, long duration, int repeatDays, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void onRequestSelectedTrackInfo(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestSigning(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull java.lang.String algorithm, @android.annotation.NonNull java.lang.String alias, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

public void onRequestSigning(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull java.lang.String algorithm, @android.annotation.NonNull java.lang.String host, int port, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

public void onRequestStartRecording(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String requestId, @android.annotation.Nullable android.net.Uri programUri) { throw new RuntimeException("Stub!"); }

public void onRequestStopRecording(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String recordingId) { throw new RuntimeException("Stub!"); }

public void onRequestStreamVolume(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestTimeShiftMode(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestTrackInfoList(@android.annotation.NonNull java.lang.String iAppServiceId) { throw new RuntimeException("Stub!"); }

public void onRequestTvRecordingInfo(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String recordingId) { throw new RuntimeException("Stub!"); }

public void onRequestTvRecordingInfoList(@android.annotation.NonNull java.lang.String iAppServiceId, int type) { throw new RuntimeException("Stub!"); }

public void onSetTvRecordingInfo(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String recordingId, @android.annotation.NonNull android.media.tv.TvRecordingInfo recordingInfo) { throw new RuntimeException("Stub!"); }

public void onSetVideoBounds(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull android.graphics.Rect rect) { throw new RuntimeException("Stub!"); }

public void onStateChanged(@android.annotation.NonNull java.lang.String iAppServiceId, int state, int err) { throw new RuntimeException("Stub!"); }

public void onTeletextAppStateChanged(@android.annotation.NonNull java.lang.String iAppServiceId, int state) { throw new RuntimeException("Stub!"); }

public void onTimeShiftCommandRequest(@android.annotation.NonNull java.lang.String iAppServiceId, @android.annotation.NonNull java.lang.String cmdType, @android.annotation.NonNull android.os.Bundle parameters) { throw new RuntimeException("Stub!"); }
}

}

