/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

import android.os.Parcelable;

/**
 * A class representing the IP configuration of a network.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IpConfiguration implements android.os.Parcelable {

IpConfiguration() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * The proxy configuration of this object.
 *
 * @return The proxy information of this object configured via
 * {@link android.net.IpConfiguration.Builder#setHttpProxy(android.net.ProxyInfo) Builder.setHttpProxy(ProxyInfo)}.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.ProxyInfo getHttpProxy() { throw new RuntimeException("Stub!"); }

/**
 * Get the current static IP configuration (possibly null). Configured via
 * {@link android.net.IpConfiguration.Builder#setStaticIpConfiguration(android.net.StaticIpConfiguration) Builder.setStaticIpConfiguration(StaticIpConfiguration)}.
 *
 * @return Current static IP configuration.
 */

@android.annotation.Nullable
public android.net.StaticIpConfiguration getStaticIpConfiguration() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.IpConfiguration> CREATOR;
static { CREATOR = null; }
/**
 * Builder used to construct {@link android.net.IpConfiguration IpConfiguration} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Construct an {@link android.net.IpConfiguration IpConfiguration}.
 *
 * @return A new {@link android.net.IpConfiguration IpConfiguration} object.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpConfiguration build() { throw new RuntimeException("Stub!"); }

/**
 * Set a proxy configuration.
 *
 * @param proxyInfo Proxy configuration.
 * This value may be {@code null}.
 * @return A {@link android.net.IpConfiguration.Builder Builder} object to allow chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpConfiguration.Builder setHttpProxy(@android.annotation.Nullable android.net.ProxyInfo proxyInfo) { throw new RuntimeException("Stub!"); }

/**
 * Set a static IP configuration.
 *
 * @param config Static IP configuration.
 * This value may be {@code null}.
 * @return A {@link android.net.IpConfiguration.Builder Builder} object to allow chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.IpConfiguration.Builder setStaticIpConfiguration(@android.annotation.Nullable android.net.StaticIpConfiguration config) { throw new RuntimeException("Stub!"); }
}

}

