/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

import android.net.wifi.SoftApConfiguration;

/**
 * The mapping of tethering interface and type.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TetheringInterface implements android.os.Parcelable {

/**
 * @param type Value is {@link android.net.TetheringManager#TETHERING_WIFI}, android.net.TetheringManager.TETHERING_USB, android.net.TetheringManager.TETHERING_BLUETOOTH, android.net.TetheringManager.TETHERING_WIFI_P2P, android.net.TetheringManager.TETHERING_NCM, android.net.TetheringManager.TETHERING_ETHERNET, or android.net.TetheringManager.TETHERING_VIRTUAL

 * @param iface This value cannot be {@code null}.
 */

public TetheringInterface(int type, @android.annotation.NonNull java.lang.String iface) { throw new RuntimeException("Stub!"); }

/**
 * @param type Value is {@link android.net.TetheringManager#TETHERING_WIFI}, android.net.TetheringManager.TETHERING_USB, android.net.TetheringManager.TETHERING_BLUETOOTH, android.net.TetheringManager.TETHERING_WIFI_P2P, android.net.TetheringManager.TETHERING_NCM, android.net.TetheringManager.TETHERING_ETHERNET, or android.net.TetheringManager.TETHERING_VIRTUAL
 
 * @param iface This value cannot be {@code null}.

 * @param softApConfig This value may be {@code null}.
 */

public TetheringInterface(int type, @android.annotation.NonNull java.lang.String iface, @android.annotation.Nullable android.net.wifi.SoftApConfiguration softApConfig) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param obj This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Get tethering interface.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getInterface() { throw new RuntimeException("Stub!"); }

/**
 * Get the SoftApConfiguration provided for this interface, if any. This will only be populated
 * for apps with the same uid that specified the configuration, or apps with permission
 * {@link android.Manifest.permission.NETWORK_SETTINGS}.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.wifi.SoftApConfiguration getSoftApConfiguration() { throw new RuntimeException("Stub!"); }

/** Get tethering type. */

public int getType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.TetheringInterface> CREATOR;
static { CREATOR = null; }
}

