/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net;

import android.Manifest;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import java.util.Set;
import java.util.concurrent.Executor;

/**
 * This class provides the APIs to control the tethering service.
 * <p> The primary responsibilities of this class are to provide the APIs for applications to
 * start tethering, stop tethering, query configuration and query status.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TetheringManager {

TetheringManager() { throw new RuntimeException("Stub!"); }

/** @hide */

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

/**
 * Start listening to tethering change events. Any new added callback will receive the last
 * tethering status right away. If callback is registered,
 * {@link android.net.TetheringManager.TetheringEventCallback#onUpstreamChanged TetheringEventCallback.onUpstreamChanged} will immediately be called. If tethering
 * has no upstream or disabled, the argument of callback will be null. The same callback object
 * cannot be registered twice.
 *
 * <br>
 * Requires {@link android.Manifest.permission#ACCESS_NETWORK_STATE}
 * @param executor the executor on which callback will be invoked.
 * This value cannot be {@code null}.
 * @param callback the callback to be called when tethering has change events.

 * This value cannot be {@code null}.
 */

public void registerTetheringEventCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.TetheringEventCallback callback) { throw new RuntimeException("Stub!"); }

/**
 * Starts tethering and runs tether provisioning for the given type if needed. If provisioning
 * fails, stopTethering will be called automatically.
 *
 * @param request a {@link android.net.TetheringManager.TetheringRequest TetheringRequest} which can specify the preferred configuration.
 * This value cannot be {@code null}.
 * @param executor {@link java.util.concurrent.Executor Executor} to specify the thread upon which the callback of
 *         TetheringRequest will be invoked.
 * This value cannot be {@code null}.
 * @param callback A callback that will be called to indicate the success status of the
 *                 tethering start request.

 * This value cannot be {@code null}.
 */

public void startTethering(@android.annotation.NonNull android.net.TetheringManager.TetheringRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.StartTetheringCallback callback) { throw new RuntimeException("Stub!"); }

/**
 * Stops tethering for the given request. Operation will fail with
 * {@link #TETHER_ERROR_UNKNOWN_REQUEST} if there is no request that matches it.

 * @param request This value cannot be {@code null}.
 
 * @param executor This value cannot be {@code null}.

 * @param callback This value cannot be {@code null}.
 */

public void stopTethering(@android.annotation.NonNull android.net.TetheringManager.TetheringRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.StopTetheringCallback callback) { throw new RuntimeException("Stub!"); }

/**
 * Remove tethering event callback previously registered with
 * {@link #registerTetheringEventCallback}.
 *
 * <br>
 * Requires {@link android.Manifest.permission#TETHER_PRIVILEGED} or {@link android.Manifest.permission#ACCESS_NETWORK_STATE}
 * @param callback previously registered callback.

 * This value cannot be {@code null}.
 */

public void unregisterTetheringEventCallback(@android.annotation.NonNull android.net.TetheringManager.TetheringEventCallback callback) { throw new RuntimeException("Stub!"); }

/**
 * Indicates that this tethering connection will provide connectivity beyond this device (e.g.,
 * global Internet access).
 */

public static final int CONNECTIVITY_SCOPE_GLOBAL = 1; // 0x1

/**
 * Wifi tethering type.
 * @see #startTethering.
 */

public static final int TETHERING_WIFI = 0; // 0x0

public static final int TETHER_ERROR_DHCPSERVER_ERROR = 12; // 0xc

public static final int TETHER_ERROR_DISABLE_FORWARDING_ERROR = 9; // 0x9

public static final int TETHER_ERROR_DUPLICATE_REQUEST = 18; // 0x12

public static final int TETHER_ERROR_ENABLE_FORWARDING_ERROR = 8; // 0x8

public static final int TETHER_ERROR_ENTITLEMENT_UNKNOWN = 13; // 0xd

public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10; // 0xa

public static final int TETHER_ERROR_INTERNAL_ERROR = 5; // 0x5

public static final int TETHER_ERROR_NO_ACCESS_TETHERING_PERMISSION = 15; // 0xf

public static final int TETHER_ERROR_NO_CHANGE_TETHERING_PERMISSION = 14; // 0xe

public static final int TETHER_ERROR_NO_ERROR = 0; // 0x0

public static final int TETHER_ERROR_PROVISIONING_FAILED = 11; // 0xb

public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2; // 0x2

public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6; // 0x6

public static final int TETHER_ERROR_UNAVAIL_IFACE = 4; // 0x4

public static final int TETHER_ERROR_UNKNOWN_IFACE = 1; // 0x1

public static final int TETHER_ERROR_UNKNOWN_REQUEST = 17; // 0x11

public static final int TETHER_ERROR_UNKNOWN_TYPE = 16; // 0x10

public static final int TETHER_ERROR_UNSUPPORTED = 3; // 0x3

public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7; // 0x7
/**
 * Callback for use with {@link #startTethering} to find out whether tethering succeeded.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface StartTetheringCallback {

/**
 * Called when starting tethering failed.
 *
 * @param error The error that caused the failure.

 * Value is {@link android.net.TetheringManager#TETHER_ERROR_SERVICE_UNAVAIL}, {@link android.net.TetheringManager#TETHER_ERROR_UNSUPPORTED}, {@link android.net.TetheringManager#TETHER_ERROR_INTERNAL_ERROR}, {@link android.net.TetheringManager#TETHER_ERROR_NO_CHANGE_TETHERING_PERMISSION}, {@link android.net.TetheringManager#TETHER_ERROR_UNKNOWN_TYPE}, or {@link android.net.TetheringManager#TETHER_ERROR_DUPLICATE_REQUEST}
 */

public default void onTetheringFailed(int error) { throw new RuntimeException("Stub!"); }

/**
 * Called when tethering has been successfully started.
 */

public default void onTetheringStarted() { throw new RuntimeException("Stub!"); }
}

/**
 * Callback for use with {@link #stopTethering} to find out whether stop tethering succeeded.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface StopTetheringCallback {

/**
 * Called when starting tethering failed.
 *
 * @param error The error that caused the failure.

 * Value is {@link android.net.TetheringManager#TETHER_ERROR_NO_ERROR}, or {@link android.net.TetheringManager#TETHER_ERROR_UNKNOWN_REQUEST}
 */

public default void onStopTetheringFailed(int error) { throw new RuntimeException("Stub!"); }

/**
 * Called when tethering has been successfully stopped.
 */

public default void onStopTetheringSucceeded() { throw new RuntimeException("Stub!"); }
}

/**
 * Callback for use with {@link registerTetheringEventCallback} to find out tethering
 * upstream status.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TetheringEventCallback {

/**
 * Called when there was a change in the list of tethered interfaces.
 *
 * <p>This will be called immediately after the callback is registered, and may be called
 * multiple times later upon changes.
 * @param interfaces The set of 0 or more TetheringInterface of currently tethered
 * interface.

 * This value cannot be {@code null}.
 */

public default void onTetheredInterfacesChanged(@android.annotation.NonNull java.util.Set<android.net.TetheringInterface> interfaces) { throw new RuntimeException("Stub!"); }
}

/**
 *  Use with {@link #startTethering} to specify additional parameters when starting tethering.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TetheringRequest implements android.os.Parcelable {

TetheringRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Get the desired SoftApConfiguration of the request, if one was specified.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.wifi.SoftApConfiguration getSoftApConfiguration() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * String of TetheringRequest detail.
 * @hide
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.TetheringManager.TetheringRequest> CREATOR;
static { CREATOR = null; }
/** Builder used to create TetheringRequest. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

/**
 * Default constructor of Builder.
 * @param type Value is {@link android.net.TetheringManager#TETHERING_WIFI}, android.net.TetheringManager.TETHERING_USB, android.net.TetheringManager.TETHERING_BLUETOOTH, android.net.TetheringManager.TETHERING_WIFI_P2P, android.net.TetheringManager.TETHERING_NCM, android.net.TetheringManager.TETHERING_ETHERNET, or android.net.TetheringManager.TETHERING_VIRTUAL
 */

public Builder(int type) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.TetheringManager.TetheringRequest TetheringRequest} with the currently set configuration.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Set the desired SoftApConfiguration for {@link #TETHERING_WIFI}. If this is null or
 * not set, then the persistent tethering SoftApConfiguration from
 * {@link android.net.wifi.WifiManager#getSoftApConfiguration() WifiManager.getSoftApConfiguration()} will be used.
 * </p>
 * If TETHERING_WIFI is already enabled and a new request is made with a different
 * SoftApConfiguration, the request will be accepted if the device can support an
 * additional tethering Wi-Fi AP interface. Otherwise, the request will be rejected.
 * </p>
 * Non-system callers using TETHERING_WIFI must specify a SoftApConfiguration.
 *
 * <br>
 * Requires {@link android.Manifest.permission#TETHER_PRIVILEGED}
 * @param softApConfig SoftApConfiguration to use.
 * This value may be {@code null}.
 * @throws java.lang.IllegalArgumentException if the tethering type isn't TETHERING_WIFI.
 */

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest.Builder setSoftApConfiguration(@android.annotation.Nullable android.net.wifi.SoftApConfiguration softApConfig) { throw new RuntimeException("Stub!"); }
}

}

}

