// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;


/**
 * A class configuring the HTTP connection migration functionality.
 *
 * <p>Connection migration stops open connections to servers from being destroyed when the
 * client device switches its L4 connectivity (typically the IP address as a result of using
 * a different network). This is particularly common with mobile devices losing
 * wifi connectivity and switching to cellular data, or vice versa (a.k.a. the parking lot
 * problem). QUIC uses connection identifiers which are independent of the underlying
 * transport layer to make this possible. If the client connects to a new network and wants
 * to preserve the existing connection, they can do so by using a connection identifier the server
 * knows to be a continuation of the existing connection.
 *
 * <p>The features are only available for QUIC connections and the server needs to support
 * connection migration.
 *
 * @see <a href="https://www.rfc-editor.org/rfc/rfc9000.html#section-9">Connection
 *     Migration specification</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ConnectionMigrationOptions {

ConnectionMigrationOptions() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.ConnectionMigrationOptions.Builder#setAllowNonDefaultNetworkUsage(int) Builder.setAllowNonDefaultNetworkUsage(int)}

 * @return Value is {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_UNSPECIFIED}, {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_ENABLED}, or {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_DISABLED}
 */

public int getAllowNonDefaultNetworkUsage() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.ConnectionMigrationOptions.Builder#setDefaultNetworkMigration(int) Builder.setDefaultNetworkMigration(int)}

 * @return Value is {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_UNSPECIFIED}, {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_ENABLED}, or {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_DISABLED}
 */

public int getDefaultNetworkMigration() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.ConnectionMigrationOptions.Builder#setPathDegradationMigration(int) Builder.setPathDegradationMigration(int)}

 * @return Value is {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_UNSPECIFIED}, {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_ENABLED}, or {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_DISABLED}
 */

public int getPathDegradationMigration() { throw new RuntimeException("Stub!"); }

/**
 * Option is disabled.
 */

public static final int MIGRATION_OPTION_DISABLED = 2; // 0x2

/**
 * Option is enabled.
 */

public static final int MIGRATION_OPTION_ENABLED = 1; // 0x1

/**
 * Option is unspecified, platform default value will be used.
 */

public static final int MIGRATION_OPTION_UNSPECIFIED = 0; // 0x0
/**
 * Builder for {@link android.net.http.ConnectionMigrationOptions ConnectionMigrationOptions}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Creates and returns the final {@link android.net.http.ConnectionMigrationOptions ConnectionMigrationOptions} instance, based on the
 * values in this builder.
 */

@android.annotation.NonNull
public android.net.http.ConnectionMigrationOptions build() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether connections can be migrated to an alternate network when Cronet detects
 * a degradation of the path currently in use. Requires setting
 * {@link #setPathDegradationMigration(int)} to {@link #MIGRATION_OPTION_ENABLED} to
 * have any effect.
 *
 * <p>Note: This setting can result in requests being sent on non-default metered networks,
 * eating into the users' data budgets and incurring extra costs. Make sure you're using
 * metered networks sparingly.
 *
 * @param state one of the MIGRATION_OPTION_* values
 * Value is {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_UNSPECIFIED}, {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_ENABLED}, or {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_DISABLED}
 * @return this builder for chaining
 */

@android.annotation.NonNull
public android.net.http.ConnectionMigrationOptions.Builder setAllowNonDefaultNetworkUsage(int state) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to enable the possibility of migrating connections on default network
 * change. If enabled, active QUIC connections will be migrated onto the new network when
 * the platform indicates that the default network is changing.
 *
 * @see <a href="https://developer.android.com/training/basics/network-ops/reading-network-state#listening-events">Android
 *     Network State</a>
 *
 * @param state one of the MIGRATION_OPTION_* values
 * Value is {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_UNSPECIFIED}, {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_ENABLED}, or {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_DISABLED}
 * @return this builder for chaining
 */

@android.annotation.NonNull
public android.net.http.ConnectionMigrationOptions.Builder setDefaultNetworkMigration(int state) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to enable the possibility of migrating connections if the current path is
 * performing poorly.
 *
 * <p>Depending on other configuration, this can result to migrating the connections within
 * the same default network, or to a non-default network.
 *
 * @param state one of the MIGRATION_OPTION_* values
 * Value is {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_UNSPECIFIED}, {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_ENABLED}, or {@link android.net.http.ConnectionMigrationOptions#MIGRATION_OPTION_DISABLED}
 * @return this builder for chaining
 */

@android.annotation.NonNull
public android.net.http.ConnectionMigrationOptions.Builder setPathDegradationMigration(int state) { throw new RuntimeException("Stub!"); }
}

}

