// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;


/**
 * Defines callbacks methods for {@link android.net.http.UploadDataProvider UploadDataProvider}. All methods may be called synchronously
 * or asynchronously, on any thread.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class UploadDataSink {

public UploadDataSink() { throw new RuntimeException("Stub!"); }

/**
 * Called by {@link android.net.http.UploadDataProvider UploadDataProvider} when a read fails.
 *
 * @param exception Exception passed on to the embedder.
 */

public abstract void onReadError(@android.annotation.NonNull java.lang.Exception exception);

/**
 * Called by {@link android.net.http.UploadDataProvider UploadDataProvider} when a read succeeds.
 *
 * @param finalChunk For chunked uploads, {@code true} if this is the final read. It must be
 * {@code false} for non-chunked uploads.
 */

public abstract void onReadSucceeded(boolean finalChunk);

/**
 * Called by {@link android.net.http.UploadDataProvider UploadDataProvider} when a rewind fails, or if rewinding uploads is not
 * supported.
 *
 * @param exception Exception passed on to the embedder.
 */

public abstract void onRewindError(@android.annotation.NonNull java.lang.Exception exception);

/**
 * Called by {@link android.net.http.UploadDataProvider UploadDataProvider} when a rewind succeeds.
 */

public abstract void onRewindSucceeded();
}

