/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.nsd;


/**
 * Encapsulates parameters for {@link android.net.nsd.NsdManager#registerService NsdManager.registerService}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdvertisingRequest implements android.os.Parcelable {

AdvertisingRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object other) { throw new RuntimeException("Stub!"); }

/**
 * @return the flags affecting advertising behavior.

 * Value is either <code>0</code> or {@link android.net.nsd.AdvertisingRequest#FLAG_SKIP_PROBING}
 */

public long getFlags() { throw new RuntimeException("Stub!"); }

/**
 * @return the service advertisement protocol.

 * Value is {@link android.net.nsd.NsdManager#PROTOCOL_DNS_SD}
 */

public int getProtocolType() { throw new RuntimeException("Stub!"); }

/**
 * @return the {@link android.net.nsd.NsdServiceInfo NsdServiceInfo} describing the service to advertise.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.NsdServiceInfo getServiceInfo() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.nsd.AdvertisingRequest> CREATOR;
static { CREATOR = null; }

/**
 * Skip the probing step when advertising.
 *
 * <p>This must only be used when the service name ({@link android.net.nsd.NsdServiceInfo#getServiceName() NsdServiceInfo.getServiceName()} is
 * known to be unique and cannot possibly be used by any other device on the network.
 */

public static final long FLAG_SKIP_PROBING = 2L; // 0x2L
/**
 * A builder for creating new {@link android.net.nsd.AdvertisingRequest AdvertisingRequest} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.net.nsd.AdvertisingRequest.Builder Builder} object.
 * @param serviceInfo the {@link android.net.nsd.NsdServiceInfo NsdServiceInfo} describing the service to advertise.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new {@link android.net.nsd.AdvertisingRequest AdvertisingRequest} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.AdvertisingRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets advertising configuration flags.
 *
 * @param flags flags to use for advertising.
 
 * Value is either <code>0</code> or {@link android.net.nsd.AdvertisingRequest#FLAG_SKIP_PROBING}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.AdvertisingRequest.Builder setFlags(long flags) { throw new RuntimeException("Stub!"); }

/**
 * Sets the protocol to use for advertising.
 * @param protocolType the advertising protocol to use.
 
 * Value is {@link android.net.nsd.NsdManager#PROTOCOL_DNS_SD}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.AdvertisingRequest.Builder setProtocolType(int protocolType) { throw new RuntimeException("Stub!"); }
}

}

