/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.nsd;

import android.net.Network;
import android.os.Parcelable;
import java.util.List;
import java.util.Set;

/**
 * A class representing service information for network service discovery
 * @see android.net.nsd.NsdManager
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class NsdServiceInfo implements android.os.Parcelable {

public NsdServiceInfo() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve attributes as a map of String keys to byte[] values. The attributes map is only
 * valid for a resolved service.
 *
 * <p> The returned map is unmodifiable; changes must be made through {@link #setAttribute} and
 * {@link #removeAttribute}.
 */

public java.util.Map<java.lang.String,byte[]> getAttributes() { throw new RuntimeException("Stub!"); }

/**
 * Get the host address. The host address is valid for a resolved service.
 *
 * @deprecated Use {@link #getHostAddresses()} to get the entire list of addresses for the host.
 */

@Deprecated
public java.net.InetAddress getHost() { throw new RuntimeException("Stub!"); }

/**
 * Get the host addresses.
 *
 * All host addresses are valid for the resolved service.
 * All addresses share the same port
 * @see #getPort()

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.net.InetAddress> getHostAddresses() { throw new RuntimeException("Stub!"); }

/**
 * Get the hostname.
 *
 * <p>When a service is resolved through {@link android.net.nsd.NsdManager#resolveService NsdManager.resolveService} or
 * {@link android.net.nsd.NsdManager#registerServiceInfoCallback NsdManager.registerServiceInfoCallback}, this returns the hostname of the resolved
 * service. In all other cases, this will be null. The top level domain ".local." is omitted.
 * For example, this returns "MyHost" when the service's hostname is "MyHost.local.".
 */

@android.annotation.Nullable
public java.lang.String getHostname() { throw new RuntimeException("Stub!"); }

/**
 * Get the network where the service can be found.
 *
 * This is set if this {@link android.net.nsd.NsdServiceInfo NsdServiceInfo} was obtained from
 * {@link android.net.nsd.NsdManager#discoverServices NsdManager.discoverServices} or {@link android.net.nsd.NsdManager#resolveService NsdManager.resolveService}, unless the service
 * was found on a network interface that does not have a {@link android.net.Network Network} (such as a tethering
 * downstream, where services are advertised from devices connected to this device via
 * tethering).

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }

/**
 * Get port number. The port number is valid for a resolved service.
 *
 * The port is valid for all addresses.
 * @see #getHostAddresses()
 */

public int getPort() { throw new RuntimeException("Stub!"); }

/** Get the service name */

public java.lang.String getServiceName() { throw new RuntimeException("Stub!"); }

/** Get the service type */

public java.lang.String getServiceType() { throw new RuntimeException("Stub!"); }

/**
 * Returns subtypes of this service instance.
 *
 * When this object is returned by the service discovery/browse APIs (etc. {@link android.net.nsd.NsdManager.DiscoveryListener NsdManager.DiscoveryListener}), the return value may or may not include the subtypes of this
 * service.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getSubtypes() { throw new RuntimeException("Stub!"); }

/** Remove an attribute by key */

public void removeAttribute(java.lang.String key) { throw new RuntimeException("Stub!"); }

/**
 * Add a service attribute as a key/value pair.
 *
 * <p> Service attributes are included as DNS-SD TXT record pairs.
 *
 * <p> The key must be US-ASCII printable characters, excluding the '=' character.  Values may
 * be UTF-8 strings or null.  The total length of key + value must be less than 255 bytes.
 *
 * <p> Keys should be short, ideally no more than 9 characters, and unique per instance of
 * {@link android.net.nsd.NsdServiceInfo NsdServiceInfo}.  Calling {@link #setAttribute} twice with the same key will overwrite
 * first value.
 */

public void setAttribute(java.lang.String key, java.lang.String value) { throw new RuntimeException("Stub!"); }

/**
 * Set the host address
 *
 * @deprecated Use {@link #setHostAddresses(java.util.List)} to set multiple addresses for the host.
 */

@Deprecated
public void setHost(java.net.InetAddress s) { throw new RuntimeException("Stub!"); }

/**
 * Set the host addresses.
 *
 * <p>When registering hosts/services, there can only be one registration including address
 * records for a given hostname.
 *
 * <p>For example, if a client registers a service with the hostname "MyHost" and the address
 * records of 192.168.1.1 and 192.168.1.2, then other registrations for the hostname "MyHost"
 * must not have any address record, otherwise there will be a conflict.

 * @param addresses This value cannot be {@code null}.
 */

public void setHostAddresses(@android.annotation.NonNull java.util.List<java.net.InetAddress> addresses) { throw new RuntimeException("Stub!"); }

/**
 * Set the network where the service can be found.
 * @param network The network, or null to search for, or to announce, the service on all
 *                connected networks.
 */

public void setNetwork(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

/** Set port number */

public void setPort(int p) { throw new RuntimeException("Stub!"); }

/** Set the service name */

public void setServiceName(java.lang.String s) { throw new RuntimeException("Stub!"); }

/** Set the service type */

public void setServiceType(java.lang.String s) { throw new RuntimeException("Stub!"); }

/**
 * Sets the subtypes to be advertised for this service instance.
 *
 * The elements in {@code subtypes} should be the subtype identifiers which have the trailing
 * "._sub" removed. For example, the subtype should be "_printer" for
 * "_printer._sub._http._tcp.local".
 *
 * Only one subtype will be registered if multiple elements of {@code subtypes} have the same
 * case-insensitive value.

 * @param subtypes This value cannot be {@code null}.
 */

public void setSubtypes(@android.annotation.NonNull java.util.Set<java.lang.String> subtypes) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.nsd.NsdServiceInfo> CREATOR;
static { CREATOR = null; }
}

