/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.wifi;


/**
 * Contains information about a Wifi channel and bitmask of Wifi operational modes allowed on that
 * channel. Use {@link android.net.wifi.WifiManager#getAllowedChannels(int,int) WifiManager.getAllowedChannels(int, int)} to retrieve the list of channels
 * filtered by regulatory constraints. Use {@link android.net.wifi.WifiManager#getUsableChannels(int,int) WifiManager.getUsableChannels(int, int)} to
 * retrieve the list of channels filtered by regulatory and dynamic constraints like concurrency and
 * interference due to other radios.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiAvailableChannel implements android.os.Parcelable {

/**
 * @param opModes Value is either <code>0</code> or a combination of {@link android.net.wifi.WifiAvailableChannel#OP_MODE_STA}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_SAP}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_WIFI_DIRECT_CLI}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_WIFI_DIRECT_GO}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_WIFI_AWARE}, and {@link android.net.wifi.WifiAvailableChannel#OP_MODE_TDLS}
 */

public WifiAvailableChannel(int freq, int opModes) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Get the channel bandwidth, which indicates the amount of frequency spectrum allocated for
 * data transmission within a channel.
 *
 * @return the bandwidth representation of the Wi-Fi channel from
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ ScanResult.CHANNEL_WIDTH_20MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ ScanResult.CHANNEL_WIDTH_40MHZ},
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ ScanResult.CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ ScanResult.CHANNEL_WIDTH_160MHZ},
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ_PLUS_MHZ ScanResult.CHANNEL_WIDTH_80MHZ_PLUS_MHZ} or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ ScanResult.CHANNEL_WIDTH_320MHZ}.

 * Value is {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ_PLUS_MHZ}, or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ}
 */

public int getChannelWidth() { throw new RuntimeException("Stub!"); }

/**
 * Get the channel frequency in MHz.
 */

public int getFrequencyMhz() { throw new RuntimeException("Stub!"); }

/**
 * Get the operational modes allowed on a channel.

 * @return Value is either <code>0</code> or a combination of {@link android.net.wifi.WifiAvailableChannel#OP_MODE_STA}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_SAP}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_WIFI_DIRECT_CLI}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_WIFI_DIRECT_GO}, {@link android.net.wifi.WifiAvailableChannel#OP_MODE_WIFI_AWARE}, and {@link android.net.wifi.WifiAvailableChannel#OP_MODE_TDLS}
 */

public int getOperationalModes() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiAvailableChannel> CREATOR;
static { CREATOR = null; }

/**
 * Wifi SoftAp (Mobile Hotspot) operational mode.
 */

public static final int OP_MODE_SAP = 2; // 0x2

/**
 * Wifi Infrastructure client (STA) operational mode.
 */

public static final int OP_MODE_STA = 1; // 0x1

/**
 * Wifi Tunneled Direct Link Setup (TDLS) operational mode.
 */

public static final int OP_MODE_TDLS = 32; // 0x20

/**
 * Wifi Aware (NAN) operational mode.
 */

public static final int OP_MODE_WIFI_AWARE = 16; // 0x10

/**
 * Wifi Direct client (CLI) operational mode.
 */

public static final int OP_MODE_WIFI_DIRECT_CLI = 4; // 0x4

/**
 * Wifi Direct Group Owner (GO) operational mode.
 */

public static final int OP_MODE_WIFI_DIRECT_GO = 8; // 0x8
}

