/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

import android.net.MacAddress;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.os.ParcelUuid;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import java.util.List;

/**
 * The Network Suggestion object is used to provide a Wi-Fi network for consideration when
 * auto-connecting to networks. Apps cannot directly create this object, they must use
 * {@link android.net.wifi.WifiNetworkSuggestion.Builder#build() WifiNetworkSuggestion.Builder.build()} to obtain an instance of this object.
 *<p>
 * Apps can provide a list of such networks to the platform using
 * {@link android.net.wifi.WifiManager#addNetworkSuggestions(java.util.List) WifiManager.addNetworkSuggestions(List)}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiNetworkSuggestion implements android.os.Parcelable {

WifiNetworkSuggestion() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Get the BSSID, or null if unset.
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setBssid(MacAddress)
 */

@android.annotation.Nullable
public android.net.MacAddress getBssid() { throw new RuntimeException("Stub!"); }

/**
 * Get the WifiEnterpriseConfig, or null if unset.
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWapiEnterpriseConfig(WifiEnterpriseConfig)
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWpa2EnterpriseConfig(WifiEnterpriseConfig)
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWpa3EnterpriseConfig(WifiEnterpriseConfig)
 */

@android.annotation.Nullable
public android.net.wifi.WifiEnterpriseConfig getEnterpriseConfig() { throw new RuntimeException("Stub!"); }

/**
 * Get the MAC randomization method.
 * @return one of {@code RANDOMIZATION_*} values
 * Value is {@link android.net.wifi.WifiNetworkSuggestion#RANDOMIZATION_PERSISTENT}, or {@link android.net.wifi.WifiNetworkSuggestion#RANDOMIZATION_NON_PERSISTENT}
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setMacRandomizationSetting(int)
 */

public int getMacRandomizationSetting() { throw new RuntimeException("Stub!"); }

/**
 * Get the passphrase, or null if unset.
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWapiPassphrase(String)
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWpa2Passphrase(String)
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWpa3Passphrase(String)
 */

@android.annotation.Nullable
public java.lang.String getPassphrase() { throw new RuntimeException("Stub!"); }

/**
 * Get the {@link android.net.wifi.hotspot2.PasspointConfiguration PasspointConfiguration} associated with this Suggestion, or null if this
 * Suggestion is not for a Passpoint network.
 */

@android.annotation.Nullable
public android.net.wifi.hotspot2.PasspointConfiguration getPasspointConfig() { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setPriority(int)
 * @return Value is 0 or greater
 */

public int getPriority() { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setPriorityGroup(int)

 * @return Value is 0 or greater
 */

public int getPriorityGroup() { throw new RuntimeException("Stub!"); }

/**
 * Return the unicode SSID of the network, or null if this is a Passpoint network or the SSID is
 * non-unicode.
 * <p>
 * Note: use {@link #getWifiSsid()} which supports both unicode and non-unicode SSID.
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setSsid(String)
 */

@android.annotation.Nullable
public java.lang.String getSsid() { throw new RuntimeException("Stub!"); }

/**
 * Get the subscription Group UUID of the suggestion
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setSubscriptionGroup(ParcelUuid)
 * @return Uuid represent a Subscription Group

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.ParcelUuid getSubscriptionGroup() { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setSubscriptionId(int)
 */

public int getSubscriptionId() { throw new RuntimeException("Stub!"); }

/**
 * Return the {@link android.net.wifi.WifiSsid WifiSsid} of the network, or null if this is a Passpoint network.
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setWifiSsid(WifiSsid)
 * @return An object representing the SSID the network. {@code null} for passpoint network.
 */

@android.annotation.Nullable
public android.net.wifi.WifiSsid getWifiSsid() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setIsAppInteractionRequired(boolean) */

public boolean isAppInteractionRequired() { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setCarrierMerged(boolean)
 */

public boolean isCarrierMerged() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setCredentialSharedWithUser(boolean) */

public boolean isCredentialSharedWithUser() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setIsEnhancedOpen(boolean)  */

public boolean isEnhancedOpen() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setIsHiddenSsid(boolean)  */

public boolean isHiddenSsid() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setIsInitialAutojoinEnabled(boolean)  */

public boolean isInitialAutojoinEnabled() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setIsMetered(boolean)  */

public boolean isMetered() { throw new RuntimeException("Stub!"); }

/**
 * Return if a suggestion is for a restricted network
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setRestricted(boolean)
 * @return true if the suggestion is restricted, false otherwise
 */

public boolean isRestricted() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setUntrusted(boolean)  */

public boolean isUntrusted() { throw new RuntimeException("Stub!"); }

/** @see android.net.wifi.WifiNetworkSuggestion.Builder#setIsUserInteractionRequired(boolean)  */

public boolean isUserInteractionRequired() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.wifi.WifiNetworkSuggestion.Builder#setWifi7Enabled(boolean) Builder.setWifi7Enabled(boolean)}
 */

public boolean isWifi7Enabled() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiNetworkSuggestion> CREATOR;
static { CREATOR = null; }

/**
 * With this option, the randomized MAC address will periodically get re-randomized, and
 * the randomized MAC address will change if the suggestion is removed and then added back.
 */

public static final int RANDOMIZATION_NON_PERSISTENT = 1; // 0x1

/**
 * Generate a randomized MAC from a secret seed and information from the Wi-Fi configuration
 * (SSID or Passpoint profile) and reuse it for all connections to this network. The
 * randomized MAC address for this network will stay the same for each subsequent association
 * until the device undergoes factory reset.
 */

public static final int RANDOMIZATION_PERSISTENT = 0; // 0x0
/**
 * Builder used to create {@link android.net.wifi.WifiNetworkSuggestion WifiNetworkSuggestion} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Create a network suggestion object for use in
 * {@link android.net.wifi.WifiManager#addNetworkSuggestions(java.util.List) WifiManager.addNetworkSuggestions(List)}.
 *
 *<p class="note">
 * <b>Note:</b> Apps can set a combination of SSID using {@link #setSsid(java.lang.String)} and BSSID
 * using {@link #setBssid(android.net.MacAddress)} to provide more fine grained network suggestions to
 * the platform.
 * </p>
 *
 * For example:
 * To provide credentials for one open, one WPA2, one WPA3 network with their
 * corresponding SSID's and one with Passpoint config:
 *
 * <pre>{@code
 * final WifiNetworkSuggestion suggestion1 =
 *      new Builder()
 *      .setSsid("test111111")
 *      .build();
 * final WifiNetworkSuggestion suggestion2 =
 *      new Builder()
 *      .setSsid("test222222")
 *      .setWpa2Passphrase("test123456")
 *      .build();
 * final WifiNetworkSuggestion suggestion3 =
 *      new Builder()
 *      .setSsid("test333333")
 *      .setWpa3Passphrase("test6789")
 *      .build();
 * final PasspointConfiguration passpointConfig= new PasspointConfiguration();
 * // configure passpointConfig to include a valid Passpoint configuration
 * final WifiNetworkSuggestion suggestion4 =
 *      new Builder()
 *      .setPasspointConfig(passpointConfig)
 *      .build();
 * final List<WifiNetworkSuggestion> suggestionsList =
 *      new ArrayList<WifiNetworkSuggestion> { {
 *          add(suggestion1);
 *          add(suggestion2);
 *          add(suggestion3);
 *          add(suggestion4);
 *      } };
 * final WifiManager wifiManager =
 *      context.getSystemService(Context.WIFI_SERVICE);
 * wifiManager.addNetworkSuggestions(suggestionsList);
 * // ...
 * }</pre>
 *
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion WifiNetworkSuggestion}
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalStateException on invalid params set
 * @see android.net.wifi.WifiNetworkSuggestion
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion build() { throw new RuntimeException("Stub!"); }

/**
 * Set the BSSID to use for filtering networks from scan results. Will only match network
 * whose BSSID is identical to the specified value.
 * <p>
 * <li Sets a specific BSSID for the network suggestion. If set, only the specified BSSID
 * with the specified SSID will be considered for connection.
 * <li>If set, only the specified BSSID with the specified SSID will be considered for
 * connection.</li>
 * <li>If not set, all BSSIDs with the specified SSID will be considered for connection.
 * </li>
 * <li>Overrides any previous value set using {@link #setBssid(android.net.MacAddress)}.</li>
 *
 * @param bssid BSSID of the network.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setBssid(@android.annotation.NonNull android.net.MacAddress bssid) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the suggestion represents a carrier merged network. A carrier merged
 * Wi-Fi network is treated as part of the mobile carrier network. Such configuration may
 * impact the user interface and data usage accounting.
 * <p>
 * Only carriers with the
 * {@link android.telephony.CarrierConfigManager#KEY_CARRIER_PROVISIONS_WIFI_MERGED_NETWORKS_BOOL}
 * flag set to {@code true} may use this API.
 * <p>
 * <li>A suggestion marked as carrier merged must be metered enterprise network with a valid
 * subscription Id set.
 * @see #setIsMetered(boolean)
 * @see #setSubscriptionId(int)
 * @see #setWpa2EnterpriseConfig(WifiEnterpriseConfig)
 * @see #setWpa3Enterprise192BitModeConfig(WifiEnterpriseConfig)
 * @see #setWpa3EnterpriseStandardModeConfig(WifiEnterpriseConfig)
 * @see #setPasspointConfig(PasspointConfiguration)
 * </li>
 * <li>If not set, defaults to false (i.e. not a carrier merged network.)</li>
 * </p>
 * @param isCarrierMerged Boolean indicating whether the network is treated a carrier
 *                               merged network (if true) or non-merged network (if false);
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setCarrierMerged(boolean isCarrierMerged) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the network credentials provided with this suggestion can be used by
 * the user to explicitly (manually) connect to this network. If true this network will
 * appear in the Wi-Fi Picker (in Settings) and the user will be able to select and connect
 * to it with the provided credentials. If false, the user will need to enter network
 * credentials and the resulting configuration will become a user saved network.
 * <p>
 * <li>Note: Only valid for secure (non-open) networks.
 * <li>If not set, defaults to true (i.e. allow user to manually connect) for secure
 * networks and false for open networks.</li>
 *
 * @param isShared {@code true} to indicate that the credentials may be used by the user to
 *                              manually connect to the network, {@code false} otherwise.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setCredentialSharedWithUser(boolean isShared) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the app needs to log in to a captive portal to obtain Internet access.
 * <p>
 * This will dictate if the directed broadcast
 * {@link android.net.wifi.WifiManager#ACTION_WIFI_NETWORK_SUGGESTION_POST_CONNECTION WifiManager.ACTION_WIFI_NETWORK_SUGGESTION_POST_CONNECTION} will be sent to the
 * app after successfully connecting to the network.
 * Use this for captive portal type networks where the app needs to authenticate the user
 * before the device can access the network.
 * <p>
 * <li>If not set, defaults to false (i.e no app interaction required).</li>
 *
 * @param isAppInteractionRequired {@code true} to indicate that app interaction is
 *                                 required, {@code false} otherwise.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsAppInteractionRequired(boolean isAppInteractionRequired) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether this represents an Enhanced Open (OWE) network.
 *
 * @param isEnhancedOpen {@code true} to indicate that the network used enhanced open,
 *                       {@code false} otherwise.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsEnhancedOpen(boolean isEnhancedOpen) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether this represents a hidden network.
 * <p>
 * <li>If not set, defaults to false (i.e not a hidden network).</li>
 *
 * @param isHiddenSsid {@code true} to indicate that the network is hidden, {@code false}
 *                     otherwise.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsHiddenSsid(boolean isHiddenSsid) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the suggestion is created with auto-join enabled or disabled. The
 * user may modify the auto-join configuration of a suggestion directly once the device
 * associates to the network.
 * <p>
 * If auto-join is initialized as disabled the user may still be able to manually connect
 * to the network. Therefore, disabling auto-join only makes sense if
 * {@link #setCredentialSharedWithUser(boolean)} is set to true (the default) which
 * itself implies a secure (non-open) network.
 * <p>
 * If not set, defaults to true (i.e. auto-join is initialized as enabled).
 *
 * @param enabled true for initializing with auto-join enabled (the default), false to
 *                initializing with auto-join disabled.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsInitialAutojoinEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether this network is metered.
 * <p>
 * <li>If not set, defaults to detect automatically.</li>
 *
 * @param isMetered {@code true} to indicate that the network is metered, {@code false}
 *                  for not metered.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsMetered(boolean isMetered) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the user needs to log in to a captive portal to obtain Internet access.
 * <p>
 * <li>If not set, defaults to false (i.e no user interaction required).</li>
 *
 * @param isUserInteractionRequired {@code true} to indicate that user interaction is
 *                                  required, {@code false} otherwise.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsUserInteractionRequired(boolean isUserInteractionRequired) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the suggestion represents an SAE network which only
 * accepts Hash-to-Element mode.
 * If this is enabled, Hunting & Pecking mode is disabled and only Hash-to-Element
 * mode is used for this network.
 * This is only valid for an SAE network which is configured using the
 * {@link #setWpa3Passphrase}.
 * Before calling this API, the application should check Hash-to-Element support using
 * {@link android.net.wifi.WifiManager#isWpa3SaeH2eSupported() WifiManager.isWpa3SaeH2eSupported()}.
 *
 * @param enable Boolean indicating whether the network only accepts Hash-to-Element mode,
 *        default is false.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setIsWpa3SaeH2eOnlyModeEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

/**
 * Specifies the MAC randomization method.
 * <p>
 * Suggested networks will never use the device (factory) MAC address to associate to the
 * network - instead they use a locally generated random MAC address. This method controls
 * the strategy for generating the random MAC address. If not set, defaults to
 * {@link #RANDOMIZATION_PERSISTENT}.
 *
 * @param macRandomizationSetting - one of {@code RANDOMIZATION_*} values
 * Value is {@link android.net.wifi.WifiNetworkSuggestion#RANDOMIZATION_PERSISTENT}, or {@link android.net.wifi.WifiNetworkSuggestion#RANDOMIZATION_NON_PERSISTENT}
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setMacRandomizationSetting(int macRandomizationSetting) { throw new RuntimeException("Stub!"); }

/**
 * Set the associated Passpoint configuration for this network. Needed for authenticating
 * to Hotspot 2.0 networks. See {@link android.net.wifi.hotspot2.PasspointConfiguration PasspointConfiguration} for description.
 *
 * @param passpointConfig Instance of {@link android.net.wifi.hotspot2.PasspointConfiguration PasspointConfiguration}.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if passpoint configuration is invalid.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setPasspointConfig(@android.annotation.NonNull android.net.wifi.hotspot2.PasspointConfiguration passpointConfig) { throw new RuntimeException("Stub!"); }

/**
 * Specify the priority of this network among other network suggestions provided by the same
 * app and within the same priority group, see {@link #setPriorityGroup(int)}. Priorities
 * have no impact on suggestions by other apps or suggestions from the same app using a
 * different priority group. The higher the number, the higher the priority
 * (i.e value of 0 = lowest priority). If not set, defaults to a lower priority than any
 * assigned priority.
 *
 * @param priority Integer number representing the priority among suggestions by the app.
 * Value is 0 or greater
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the priority value is negative.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setPriority(int priority) { throw new RuntimeException("Stub!"); }

/**
 * Suggested networks are considered as part of a pool of all suggested networks and other
 * networks (e.g.&nbsp;saved networks) - one of which will be selected.
 * <ul>
 * <li> Any app can suggest any number of networks. </li>
 * <li> Priority: only the highest priority (0 being the lowest) currently visible suggested
 * network or networks (multiple suggested networks may have the same priority) are added to
 * the network selection pool.</li>
 * </ul>
 * <p>
 * However, this restricts a suggesting app to have a single group of networks which can be
 * prioritized. In some circumstances multiple groups are useful: for instance, suggesting
 * networks for 2 different SIMs - each of which may have its own priority order.
 * <p>
 * Priority group: creates a separate priority group. Only the highest priority, currently
 * visible suggested network or networks, within each priority group are included in the
 * network selection pool.
 * <p>
 * Specify an arbitrary integer only used as the priority group. Use with
 * {@link #setPriority(int)}.
 *
 * @param priorityGroup priority group id, if not set default is 0.
 * Value is 0 or greater
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setPriorityGroup(int priorityGroup) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the system will bring up the network (if selected) as restricted. A
 * restricted network has its {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED NetworkCapabilities.NET_CAPABILITY_NOT_RESTRICTED}
 * capability removed. The Wi-Fi network selection process may use this information to
 * influence priority of the suggested network for Wi-Fi network selection (most likely to
 * reduce it). The connectivity service may use this information to influence the overall
 * network configuration of the device.
 * <p>
 * <li> These suggestions are only considered for network selection if a
 * {@link android.net.NetworkRequest NetworkRequest} without {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED NetworkCapabilities.NET_CAPABILITY_NOT_RESTRICTED}
 * capability is filed.
 * <li> A restricted network's credentials may not be shared with the user using
 * {@link #setCredentialSharedWithUser(boolean)}.</li>
 * <li> If not set, defaults to false (i.e. network is unrestricted).</li>
 *
 * @param isRestricted Boolean indicating whether the network should be brought up
 *                     restricted (if true) or unrestricted (if false).
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setRestricted(boolean isRestricted) { throw new RuntimeException("Stub!"); }

/**
 * Set the unicode SSID for the network.
 * <p>
 * <li>Overrides any previous value set using {@link #setSsid(java.lang.String)}.</li>
 *
 * <p>
 * Note: use {@link #setWifiSsid(android.net.wifi.WifiSsid)} which supports both unicode and non-unicode
 * SSID.
 *
 * @param ssid The SSID of the network. It must be valid Unicode.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the SSID is not valid unicode.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setSsid(@android.annotation.NonNull java.lang.String ssid) { throw new RuntimeException("Stub!"); }

/**
 * Configure the suggestion to only be used with the SIMs that belong to the Subscription
 * Group specified in this method. The suggested network will only be used by the SIM in
 * this Subscription Group and no other SIMs - even from the same carrier.
 * <p>
 * The caller is restricted to be either of:
 * <li>A carrier provisioning app.
 * <li>A carrier-privileged app - which is restricted to only specify a subscription ID
 * which belong to the same carrier which signed the app, see
 * {@link android.telephony.TelephonyManager#hasCarrierPrivileges() TelephonyManager.hasCarrierPrivileges()}.
 * <p>
 * Specifying a subscription group which doesn't match these restriction will cause the
 * suggestion to be rejected with the error code
 * {@link android.net.wifi.WifiManager#STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED WifiManager.STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED}.
 *
 * Only one of the {@link #setSubscriptionGroup(android.os.ParcelUuid)} and
 * {@link #setSubscriptionId(int)} should be called for a suggestion.
 *
 * @param groupUuid Subscription group UUID see
 * {@link android.telephony.SubscriptionManager#createSubscriptionGroup(java.util.List) SubscriptionManager.createSubscriptionGroup(List)}
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if group UUID is {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setSubscriptionGroup(@android.annotation.NonNull android.os.ParcelUuid groupUuid) { throw new RuntimeException("Stub!"); }

/**
 * Configure the suggestion to only be used with the SIM identified by the subscription
 * ID specified in this method. The suggested network will only be used by that SIM and
 * no other SIM - even from the same carrier.
 * <p>
 * The caller is restricted to be either of:
 * <li>A carrier provisioning app (which holds the
 * {@code android.Manifest.permission#NETWORK_CARRIER_PROVISIONING} permission).
 * <li>A carrier-privileged app - which is restricted to only specify a subscription ID
 * which belong to the same carrier which signed the app, see
 * {@link android.telephony.TelephonyManager#hasCarrierPrivileges() TelephonyManager.hasCarrierPrivileges()}.
 * <p>
 * Specifying a subscription ID which doesn't match these restriction will cause the
 * suggestion to be rejected with the error code
 * {@link android.net.wifi.WifiManager#STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED WifiManager.STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED}.
 *
 * Only one of the {@link #setSubscriptionGroup(android.os.ParcelUuid)} and
 * {@link #setSubscriptionId(int)} should be called for a suggestion.
 *
 * @param subscriptionId subscription ID see {@link android.telephony.SubscriptionInfo#getSubscriptionId() SubscriptionInfo.getSubscriptionId()}
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if subscriptionId equals to {@link android.telephony.SubscriptionManager#INVALID_SUBSCRIPTION_ID SubscriptionManager.INVALID_SUBSCRIPTION_ID}
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setSubscriptionId(int subscriptionId) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the system will bring up the network (if selected) as untrusted. An
 * untrusted network has its {@link android.net.NetworkCapabilities#NET_CAPABILITY_TRUSTED NetworkCapabilities.NET_CAPABILITY_TRUSTED}
 * capability removed. The Wi-Fi network selection process may use this information to
 * influence priority of the suggested network for Wi-Fi network selection (most likely to
 * reduce it). The connectivity service may use this information to influence the overall
 * network configuration of the device.
 * <p>
 * <li> These suggestions are only considered for network selection if a
 * {@link android.net.NetworkRequest NetworkRequest} without {@link android.net.NetworkCapabilities#NET_CAPABILITY_TRUSTED NetworkCapabilities.NET_CAPABILITY_TRUSTED}
 * capability is filed.
 * <li> An untrusted network's credentials may not be shared with the user using
 * {@link #setCredentialSharedWithUser(boolean)}.</li>
 * <li> If not set, defaults to false (i.e. network is trusted).</li>
 *
 * @param isUntrusted Boolean indicating whether the network should be brought up untrusted
 *                    (if true) or trusted (if false).
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setUntrusted(boolean isUntrusted) { throw new RuntimeException("Stub!"); }

/**
 * Set the associated enterprise configuration for this network. Needed for authenticating
 * to WAPI-CERT networks. See {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig} for description.
 *
 * @param enterpriseConfig Instance of {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig}.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWapiEnterpriseConfig(@android.annotation.NonNull android.net.wifi.WifiEnterpriseConfig enterpriseConfig) { throw new RuntimeException("Stub!"); }

/**
 * Set the ASCII WAPI passphrase for this network. Needed for authenticating to
 * WAPI-PSK networks.
 *
 * @param passphrase passphrase of the network.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the passphrase is not ASCII encodable.
 *
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWapiPassphrase(@android.annotation.NonNull java.lang.String passphrase) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Wi-Fi 7 is enabled for this network.
 *
 * @param enabled Enable Wi-Fi 7 if true, otherwise disable Wi-Fi 7
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWifi7Enabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Set the SSID for the network. {@link android.net.wifi.WifiSsid WifiSsid} support both unicode and non-unicode SSID.
 * <p>
 * <li>Overrides any previous value set using {@link #setWifiSsid(android.net.wifi.WifiSsid)}
 * or {@link #setSsid(java.lang.String)}.</li>
 * <p>
 * Note: this method is the superset of the {@link #setSsid(java.lang.String)}
 *
 * @param wifiSsid The SSID of the network, in {@link android.net.wifi.WifiSsid WifiSsid} format.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the wifiSsid is invalid.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWifiSsid(@android.annotation.NonNull android.net.wifi.WifiSsid wifiSsid) { throw new RuntimeException("Stub!"); }

/**
 * Set the associated enterprise configuration for this network. Needed for authenticating
 * to WPA2 enterprise networks. See {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig} for description.
 *
 * @param enterpriseConfig Instance of {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig}.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException If configuration uses server certificate but validation
 *                                  is not enabled. See {@link android.net.wifi.WifiEnterpriseConfig#isServerCertValidationEnabled() WifiEnterpriseConfig.isServerCertValidationEnabled()}
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWpa2EnterpriseConfig(@android.annotation.NonNull android.net.wifi.WifiEnterpriseConfig enterpriseConfig) { throw new RuntimeException("Stub!"); }

/**
 * Set the ASCII WPA2 passphrase for this network. Needed for authenticating to
 * WPA2-PSK networks.
 *
 * @param passphrase passphrase of the network.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the passphrase is not ASCII encodable.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWpa2Passphrase(@android.annotation.NonNull java.lang.String passphrase) { throw new RuntimeException("Stub!"); }

/**
 * Set the associated enterprise configuration for this network. Needed for authenticating
 * to WPA3-Enterprise in 192-bit security mode networks. See {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig}
 * for description. Both the client and CA certificates must be provided,
 * and must be of type of either sha384WithRSAEncryption with key length of 3072bit or
 * more (OID 1.2.840.113549.1.1.12), or ecdsa-with-SHA384 with key length of 384bit or
 * more (OID 1.2.840.10045.4.3.3).
 *
 * @param enterpriseConfig Instance of {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig}.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the EAP type or certificates do not
 *                                  meet 192-bit mode requirements.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWpa3Enterprise192BitModeConfig(@android.annotation.NonNull android.net.wifi.WifiEnterpriseConfig enterpriseConfig) { throw new RuntimeException("Stub!"); }

/**
 * Set the associated enterprise configuration for this network. Needed for authenticating
 * to WPA3-Enterprise networks (standard and 192-bit security). See
 * {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig} for description. For 192-bit security networks, both the
 * client and CA certificates must be provided, and must be of type of either
 * sha384WithRSAEncryption (OID 1.2.840.113549.1.1.12) or ecdsa-with-SHA384
 * (OID 1.2.840.10045.4.3.3).
 *
 * @deprecated use {@link #setWpa3EnterpriseStandardModeConfig(android.net.wifi.WifiEnterpriseConfig)} or
 * {@link #setWpa3Enterprise192BitModeConfig(android.net.wifi.WifiEnterpriseConfig)} to specify
 * WPA3-Enterprise type explicitly.
 *
 * @param enterpriseConfig Instance of {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig}.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException If configuration uses server certificate but validation
 *                                  is not enabled. See {@link android.net.wifi.WifiEnterpriseConfig#isServerCertValidationEnabled() WifiEnterpriseConfig.isServerCertValidationEnabled()}
 */

@Deprecated
@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWpa3EnterpriseConfig(@android.annotation.NonNull android.net.wifi.WifiEnterpriseConfig enterpriseConfig) { throw new RuntimeException("Stub!"); }

/**
 * Set the associated enterprise configuration for this network. Needed for authenticating
 * to WPA3-Enterprise standard networks. See {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig} for description.
 * For WPA3-Enterprise in 192-bit security mode networks,
 * see {@link #setWpa3Enterprise192BitModeConfig(android.net.wifi.WifiEnterpriseConfig)} for description.
 *
 * @param enterpriseConfig Instance of {@link android.net.wifi.WifiEnterpriseConfig WifiEnterpriseConfig}.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException If configuration uses server certificate but validation
 *                                  is not enabled. See {@link android.net.wifi.WifiEnterpriseConfig#isServerCertValidationEnabled() WifiEnterpriseConfig.isServerCertValidationEnabled()}
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWpa3EnterpriseStandardModeConfig(@android.annotation.NonNull android.net.wifi.WifiEnterpriseConfig enterpriseConfig) { throw new RuntimeException("Stub!"); }

/**
 * Set the ASCII WPA3 passphrase for this network. Needed for authenticating to WPA3-SAE
 * networks.
 *
 * @param passphrase passphrase of the network.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.WifiNetworkSuggestion.Builder Builder} to enable chaining of the builder method.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the passphrase is not ASCII encodable.
 */

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSuggestion.Builder setWpa3Passphrase(@android.annotation.NonNull java.lang.String passphrase) { throw new RuntimeException("Stub!"); }
}

}

