/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;


/**
 * An object providing information about a Wi-Fi Aware discovery session with a specific peer.
 * @see android.net.wifi.aware.DiscoverySessionCallback#onServiceDiscovered(ServiceDiscoveryInfo)
 * @see android.net.wifi.aware.DiscoverySessionCallback#onServiceDiscoveredWithinRange(ServiceDiscoveryInfo, int)
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ServiceDiscoveryInfo {

ServiceDiscoveryInfo() { throw new RuntimeException("Stub!"); }

/**
 * Get the filter which resulted in this service discovery. For
 * {@link android.net.wifi.aware.PublishConfig#PUBLISH_TYPE_UNSOLICITED PublishConfig.PUBLISH_TYPE_UNSOLICITED},
 * {@link android.net.wifi.aware.SubscribeConfig#SUBSCRIBE_TYPE_PASSIVE SubscribeConfig.SUBSCRIBE_TYPE_PASSIVE} discovery sessions this is the publisher's
 * match filter. For {@link android.net.wifi.aware.PublishConfig#PUBLISH_TYPE_SOLICITED PublishConfig.PUBLISH_TYPE_SOLICITED},
 * {@link android.net.wifi.aware.SubscribeConfig#SUBSCRIBE_TYPE_ACTIVE SubscribeConfig.SUBSCRIBE_TYPE_ACTIVE} discovery sessions this is the subscriber's
 * match filter.
 * @return A list of byte arrays representing the match filter. An empty list if match filter
 * is not set.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<byte[]> getMatchFilters() { throw new RuntimeException("Stub!"); }

/**
 * Get the paired device alias if the discovered device has already paired. If not null device
 * will automatically start the NAN pairing verification,
 * {@link android.net.wifi.aware.DiscoverySessionCallback#onPairingVerificationSucceed(android.net.wifi.aware.PeerHandle,java.lang.String) DiscoverySessionCallback.onPairingVerificationSucceed(PeerHandle, String)}
 * will trigger when verification is finished
 */

@android.annotation.Nullable
public java.lang.String getPairedAlias() { throw new RuntimeException("Stub!"); }

/**
 * Get the discovered device's pairing config. Can be used for the following pairing setup or
 * bootstrapping request.
 * @see android.net.wifi.aware.AwarePairingConfig

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.wifi.aware.AwarePairingConfig getPairingConfig() { throw new RuntimeException("Stub!"); }

/**
 * Get the cipher suite type specified by the publish session to be used for data-path setup.
 * @return peerCipherSuite An integer represent the cipher suite used to encrypt the data-path.

 * Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NONE}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128}, and {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}
 */

public int getPeerCipherSuite() { throw new RuntimeException("Stub!"); }

/**
 * Get the peer handle for the peer matching our discovery operation
 * @return An opaque handle representing the discovered peer.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.aware.PeerHandle getPeerHandle() { throw new RuntimeException("Stub!"); }

/**
 * Get the Security context identifier is associate with PMK for data path security config. Only
 * use for {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 Characteristics.WIFI_AWARE_CIPHER_SUITE_NCS_PK_128} and
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 Characteristics.WIFI_AWARE_CIPHER_SUITE_NCS_PK_256} to get the PMKID set by
 * {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder#setPmkId(byte[]) WifiAwareDataPathSecurityConfig.Builder.setPmkId(byte[])} from publish session.
 * This can help the Wi-Fi Aware data-path setup to select the correct PMK/PMKID
 * @return An arbitrary byte array represent the security context identifier. {@code null} if
 * Security context identifier is not set.
 */

@android.annotation.Nullable
public byte[] getScid() { throw new RuntimeException("Stub!"); }

/**
 * The service specific information (arbitrary byte array) provided by the peer as part of its
 * discovery configuration.
 * @see android.net.wifi.aware.PublishConfig.Builder#setServiceSpecificInfo(byte[])
 * @see android.net.wifi.aware.SubscribeConfig.Builder#setServiceSpecificInfo(byte[])
 * @return An arbitrary byte array represent the service specific information. {@code null} if
 * service specific information is not set.
 */

@android.annotation.Nullable
public byte[] getServiceSpecificInfo() { throw new RuntimeException("Stub!"); }
}

