/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;

import android.net.wifi.ScanResult;

/**
 * Wi-Fi Aware data-path channel information. The information can be extracted from the
 * {@link android.net.wifi.aware.WifiAwareNetworkInfo WifiAwareNetworkInfo} using {@link android.net.wifi.aware.WifiAwareNetworkInfo#getChannelInfoList() WifiAwareNetworkInfo.getChannelInfoList()} ()}.
 * Wi-Fi Aware data-path channel information includes the channel frequency, bandwidth and num of
 * the spatial streams.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiAwareChannelInfo implements android.os.Parcelable {

WifiAwareChannelInfo() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Get the channel bandwidth used by the Aware data path
 * @return one of {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ ScanResult.CHANNEL_WIDTH_20MHZ},
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ ScanResult.CHANNEL_WIDTH_40MHZ},
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ ScanResult.CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ ScanResult.CHANNEL_WIDTH_160MHZ}
 * or {@link android.net.wifi.ScanResult #CHANNEL_WIDTH_80MHZ_PLUS_MHZ}.
 
 * Value is 0 or greater

 * Value is {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ_PLUS_MHZ}, or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ}
 */

public int getChannelBandwidth() { throw new RuntimeException("Stub!"); }

/**
 * Get the channel frequency in MHZ used by the Aware data path
 * @return An integer represent the frequency of the channel in MHZ.

 * Value is 0 or greater
 */

public int getChannelFrequencyMhz() { throw new RuntimeException("Stub!"); }

/**
 * Get the number of the spatial streams used by the Aware data path
 * @return An integer represent number of the spatial streams are using in this channel.

 * Value is 0 or greater
 */

public int getSpatialStreamCount() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.aware.WifiAwareChannelInfo> CREATOR;
static { CREATOR = null; }
}

